/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import java.util.Set;
import org.exist.dom.QName;
import org.exist.security.AXSchemaType;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.Principal;
import org.exist.security.SchemaType;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class GetPrincipalMetadataFunction
extends BasicFunction {
    public static final SchemaType[] GROUP_METADATA_KEYS = new SchemaType[]{AXSchemaType.LANGUAGE, AXSchemaType.EMAIL, EXistSchemaType.DESCRIPTION};
    private static final QName qnGetAccountMetadataKeys = new QName("get-account-metadata-keys", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGetAccountMetadata = new QName("get-account-metadata", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGetGroupMetadataKeys = new QName("get-group-metadata-keys", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGetGroupMetadata = new QName("get-group-metadata", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_GET_ALL_ACCOUNT_METADATA_KEYS = new FunctionSignature(qnGetAccountMetadataKeys, "Gets a sequence of the metadata attribute keys that may be used for an account.", null, new FunctionReturnSequenceType(25, 7, "The fully qualified metadata attribute key names"));
    public static final FunctionSignature FNS_GET_ACCOUNT_METADATA_KEYS = new FunctionSignature(qnGetAccountMetadataKeys, "Gets a sequence of the metadata attribute keys present for an account", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the account to retrieve metadata from.")}, new FunctionReturnSequenceType(25, 7, "The fully qualified metadata attribute key names"));
    public static final FunctionSignature FNS_GET_ACCOUNT_METADATA = new FunctionSignature(qnGetAccountMetadata, "Gets a metadata attribute value for an account", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the account to retrieve metadata from."), new FunctionParameterSequenceType("attribute", 25, 2, "The fully qualified metadata attribute key name")}, new FunctionReturnSequenceType(22, 3, "The metadata value"));
    public static final FunctionSignature FNS_GET_ALL_GROUP_METADATA_KEYS = new FunctionSignature(qnGetGroupMetadataKeys, "Gets a sequence of the metadata attribute keys that may be used for a group.", null, new FunctionReturnSequenceType(25, 7, "The fully qualified metadata attribute key names"));
    public static final FunctionSignature FNS_GET_GROUP_METADATA_KEYS = new FunctionSignature(qnGetGroupMetadataKeys, "Gets a sequence of the metadata attribute keys present for a group", new SequenceType[]{new FunctionParameterSequenceType("group-name", 22, 2, "The name of the group to retrieve metadata from.")}, new FunctionReturnSequenceType(25, 7, "The fully qualified metadata attribute key names"));
    public static final FunctionSignature FNS_GET_GROUP_METADATA = new FunctionSignature(qnGetGroupMetadata, "Gets a metadata attribute value for a group", new SequenceType[]{new FunctionParameterSequenceType("group-name", 22, 2, "The name of the group to retrieve metadata from."), new FunctionParameterSequenceType("attribute", 25, 2, "The fully qualified metadata attribute key name")}, new FunctionReturnSequenceType(22, 3, "The metadata value"));

    public GetPrincipalMetadataFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        void var8_10;
        Sequence result = Sequence.EMPTY_SEQUENCE;
        DBBroker broker = this.getContext().getBroker();
        Subject currentUser = broker.getCurrentSubject();
        if (args.length == 0) {
            if (this.isCalledAs(qnGetAccountMetadataKeys.getLocalPart())) {
                return this.getAllAccountMetadataKeys();
            }
            if (!this.isCalledAs(qnGetGroupMetadataKeys.getLocalPart())) throw new XPathException("Unknown function");
            return this.getAllGroupMetadataKeys();
        }
        SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
        String strPrincipal = args[0].getStringValue();
        if (this.isCalledAs(qnGetAccountMetadataKeys.getLocalPart()) || this.isCalledAs(qnGetAccountMetadata.getLocalPart())) {
            if (!currentUser.hasDbaRole() && !currentUser.getUsername().equals(strPrincipal)) {
                throw new XPathException("You must be a DBA to retrieve metadata about other users, otherwise you may only retrieve metadata about yourself.");
            }
            Account account = securityManager.getAccount(strPrincipal);
        } else {
            if (!this.isCalledAs(qnGetGroupMetadataKeys.getLocalPart())) {
                if (!this.isCalledAs(qnGetGroupMetadata.getLocalPart())) throw new XPathException("Unknown function");
            }
            if (!currentUser.hasDbaRole() && !currentUser.hasGroup(strPrincipal)) {
                throw new XPathException("You must be a DBA to retrieve metadata about other groups, otherwise you may only retrieve metadata about groups you are a member of.");
            }
            Group group = securityManager.getGroup(strPrincipal);
        }
        if (var8_10 == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (this.isCalledAs(qnGetAccountMetadataKeys.getLocalPart())) return this.getPrincipalMetadataKeys((Principal)var8_10);
        if (this.isCalledAs(qnGetGroupMetadataKeys.getLocalPart())) {
            return this.getPrincipalMetadataKeys((Principal)var8_10);
        }
        if (!this.isCalledAs(qnGetAccountMetadata.getLocalPart())) {
            if (!this.isCalledAs(qnGetGroupMetadata.getLocalPart())) throw new XPathException("Unknown function");
        }
        String metadataAttributeNamespace = args[1].getStringValue();
        return this.getPrincipalMetadata((Principal)var8_10, metadataAttributeNamespace);
    }

    private Sequence getAllAccountMetadataKeys() throws XPathException {
        ValueSequence result = new ValueSequence();
        for (AXSchemaType aXSchemaType : AXSchemaType.values()) {
            result.add(new AnyURIValue(aXSchemaType.getNamespace()));
        }
        for (Enum enum_ : EXistSchemaType.values()) {
            result.add(new AnyURIValue(((EXistSchemaType)enum_).getNamespace()));
        }
        return result;
    }

    private Sequence getAllGroupMetadataKeys() throws XPathException {
        ValueSequence result = new ValueSequence();
        for (SchemaType GROUP_METADATA_KEY : GROUP_METADATA_KEYS) {
            result.add(new AnyURIValue(GROUP_METADATA_KEY.getNamespace()));
        }
        return result;
    }

    private Sequence getPrincipalMetadata(Principal principal, String metadataAttributeNamespace) {
        AXSchemaType axSchemaType = AXSchemaType.valueOfNamespace(metadataAttributeNamespace);
        String metadataValue = null;
        if (axSchemaType != null) {
            metadataValue = principal.getMetadataValue(axSchemaType);
        } else {
            EXistSchemaType exSchemaType = EXistSchemaType.valueOfNamespace(metadataAttributeNamespace);
            if (exSchemaType != null) {
                metadataValue = principal.getMetadataValue(exSchemaType);
            }
        }
        if (metadataValue == null || metadataValue.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        return new StringValue(metadataValue);
    }

    private Sequence getPrincipalMetadataKeys(Principal principal) throws XPathException {
        Set<SchemaType> metadataKeys = principal.getMetadataKeys();
        ValueSequence seq = new ValueSequence(metadataKeys.size());
        for (SchemaType schemaType : metadataKeys) {
            seq.add(new AnyURIValue(schemaType.getNamespace()));
        }
        return seq;
    }
}

