/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import java.util.ArrayList;
import java.util.List;
import org.exist.EXistException;
import org.exist.config.ConfigurationException;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.security.internal.aider.GroupAider;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GroupManagementFunction
extends BasicFunction {
    private static final QName qnCreateGroup = new QName("create-group", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnRemoveGroup = new QName("remove-group", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnDeleteGroup = new QName("delete-group", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_CREATE_GROUP = new FunctionSignature(qnCreateGroup, "Creates a User Group. The current user will be set as the group's manager.", new SequenceType[]{new FunctionParameterSequenceType("group-name", 22, 2, "The name of the group to create.")}, new SequenceType(11, 1));
    public static final FunctionSignature FNS_CREATE_GROUP_WITH_METADATA = new FunctionSignature(qnCreateGroup, "Creates a User Group. The current user will be set as the group's manager.", new SequenceType[]{new FunctionParameterSequenceType("group-name", 22, 2, "The name of the group to create."), new FunctionParameterSequenceType("description", 22, 2, "A description of the group.")}, new SequenceType(11, 1));
    public static final FunctionSignature FNS_CREATE_GROUP_WITH_MANAGERS_WITH_METADATA = new FunctionSignature(qnCreateGroup, "Creates a User Group. The current user will be set as a manager of the group in addition to the specified managers.", new SequenceType[]{new FunctionParameterSequenceType("group-name", 22, 2, "The name of the group to create."), new FunctionParameterSequenceType("managers", 22, 6, "The usernames of users that will be a manager of this group."), new FunctionParameterSequenceType("description", 22, 2, "A description of the group.")}, new SequenceType(11, 1));
    public static final FunctionSignature FNS_REMOVE_GROUP = new FunctionSignature(qnRemoveGroup, "Remove a User Group. Any resources owned by the group will be moved to the 'guest' group.", new SequenceType[]{new FunctionParameterSequenceType("group-name", 22, 2, "The group-id to delete")}, new SequenceType(11, 1));
    public static final FunctionSignature FNS_DELETE_GROUP = new FunctionSignature(qnDeleteGroup, "Removes a User Group. Any resources owned by the group will be moved to the 'guest' group.", new SequenceType[]{new FunctionParameterSequenceType("group-id", 22, 2, "The group-id to delete")}, new SequenceType(11, 1), FNS_REMOVE_GROUP);

    public GroupManagementFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        SecurityManager securityManager = this.context.getBroker().getBrokerPool().getSecurityManager();
        Subject currentSubject = this.context.getBroker().getCurrentSubject();
        try {
            String groupName = args[0].itemAt(0).getStringValue();
            if (this.isCalledAs(qnCreateGroup.getLocalPart())) {
                if (securityManager.hasGroup(groupName)) {
                    throw new XPathException("The group with name " + groupName + " already exists.");
                }
                if (!currentSubject.hasDbaRole()) {
                    throw new XPathException("Only DBA users may create a user group.");
                }
                GroupAider group = new GroupAider(groupName);
                group.addManager(currentSubject);
                if (this.getSignature().getArgumentCount() == 3) {
                    List<Account> groupManagers = this.getGroupManagers(securityManager, args[1]);
                    group.addManagers(groupManagers);
                }
                if (this.getSignature().getArgumentCount() >= 2) {
                    group.setMetadataValue(EXistSchemaType.DESCRIPTION, args[this.getSignature().getArgumentCount() - 1].toString());
                }
                securityManager.addGroup(this.context.getBroker(), (Group)group);
            } else if (this.isCalledAs(qnRemoveGroup.getLocalPart()) || this.isCalledAs(qnDeleteGroup.getLocalPart())) {
                if (!securityManager.hasGroup(groupName)) {
                    throw new XPathException("The group with name " + groupName + " does not exist.");
                }
                if (this.getArgumentCount() == 2) {
                    String successorGroupName = args[1].itemAt(0).getStringValue();
                    if (!currentSubject.hasGroup(successorGroupName)) {
                        throw new PermissionDeniedException("You must be a member of the group for which permissions should be inherited by");
                    }
                    Group successorGroup = securityManager.getGroup(successorGroupName);
                } else {
                    Group successorGroup = securityManager.getGroup("guest");
                }
                try {
                    securityManager.deleteGroup(groupName);
                }
                catch (EXistException ee) {
                    throw new XPathException((Expression)this, (Throwable)ee);
                }
            } else {
                throw new XPathException("Unknown function call: " + this.getSignature());
            }
            return Sequence.EMPTY_SEQUENCE;
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException((Expression)this, (Throwable)pde);
        }
        catch (ConfigurationException ce) {
            throw new XPathException((Expression)this, (Throwable)ce);
        }
        catch (EXistException ee) {
            throw new XPathException((Expression)this, (Throwable)ee);
        }
    }

    private List<Account> getGroupManagers(SecurityManager securityManager, Sequence seq) {
        ArrayList<Account> managers = new ArrayList<Account>();
        for (int i = 0; i < seq.getItemCount(); ++i) {
            Account account = securityManager.getAccount(seq.itemAt(i).toString());
            managers.add(account);
        }
        return managers;
    }
}

