/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.securitymanager;

import java.util.ArrayList;
import java.util.List;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class GroupMembershipFunction
extends BasicFunction {
    private static final QName qnAddGroupMember = new QName("add-group-member", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnRemoveGroupMember = new QName("remove-group-member", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGetGroupMembers = new QName("get-group-members", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnAddGroupManager = new QName("add-group-manager", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnRemoveGroupManager = new QName("remove-group-manager", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnGetGroupManagers = new QName("get-group-managers", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnIsDba = new QName("is-dba", "http://exist-db.org/xquery/securitymanager", "sm");
    private static final QName qnSetPrimaryGroup = new QName("set-user-primary-group", "http://exist-db.org/xquery/securitymanager", "sm");
    public static final FunctionSignature FNS_ADD_GROUP_MEMBER = new FunctionSignature(qnAddGroupMember, "Adds a user to a group. Can only be called by a group manager or DBA.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The name of the group whoose membership you wish to modify."), new FunctionParameterSequenceType("member", 22, 6, "The user(s) to add to the group membership.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_REMOVE_GROUP_MEMBER = new FunctionSignature(qnRemoveGroupMember, "Removes a user from a group. Can only be called by a group manager of DBA.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The name of the group whoose membership you wish to modify."), new FunctionParameterSequenceType("member", 22, 6, "The user(s) to remove from the group membership.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_GET_GROUP_MEMBERS = new FunctionSignature(qnGetGroupMembers, "Gets a list of the group members.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The group name to retrieve the list of members for.")}, new FunctionReturnSequenceType(22, 6, "The list of group members for the group $group"));
    public static final FunctionSignature FNS_ADD_GROUP_MANAGER = new FunctionSignature(qnAddGroupManager, "Adds a manager to a groups managers. Can only be called by a group manager or DBA.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The name of the group to which you wish to add a manager(s)."), new FunctionParameterSequenceType("manager", 22, 6, "The user(s) to add to the group managers.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_REMOVE_GROUP_MANAGER = new FunctionSignature(qnRemoveGroupManager, "Removes a manager from a groups managers. Can only be called by a group manager of DBA.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The name of the group from which you wish to remove a manager(s)"), new FunctionParameterSequenceType("manager", 22, 6, "The user(s) to remove from the group managers.")}, new SequenceType(10, 1));
    public static final FunctionSignature FNS_GET_GROUP_MANAGERS = new FunctionSignature(qnGetGroupManagers, "Gets a list of the group managers. Can only be called by a group manager.", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The group name to retrieve the list of managers for.")}, new FunctionReturnSequenceType(22, 6, "The list of group managers for the group $group"));
    public static final FunctionSignature FNS_IS_DBA = new FunctionSignature(qnIsDba, "Determines if the user is a DBA.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The username of the user account to check if they are a member of the DBA group.")}, new FunctionReturnSequenceType(23, 2, "true of the user is a DBA, false otherwise."));
    public static final FunctionSignature FNS_SET_USER_PRIMARY_GROUP = new FunctionSignature(qnSetPrimaryGroup, "Sets the primary group of a user account. If the user is not yet in the group, then they are added to the group first.", new SequenceType[]{new FunctionParameterSequenceType("username", 22, 2, "The name of the user account to set the primary group for."), new FunctionParameterSequenceType("group", 22, 2, "The group to set as the primary group for the user.")}, new SequenceType(10, 1));

    public GroupMembershipFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        block19: {
            result = Sequence.EMPTY_SEQUENCE;
            DBBroker broker = this.getContext().getBroker();
            Subject currentUser = broker.getCurrentSubject();
            SecurityManager securityManager = broker.getBrokerPool().getSecurityManager();
            try {
                if (this.isCalledAs(qnIsDba.getLocalPart())) {
                    String username = args[0].getStringValue();
                    if (!securityManager.hasAccount(username)) {
                        throw new XPathException("The user account with username " + username + " does not exist.");
                    }
                    Account account = securityManager.getAccount(username);
                    result = BooleanValue.valueOf(securityManager.hasAdminPrivileges(account));
                    break block19;
                }
                if (this.isCalledAs(qnSetPrimaryGroup.getLocalPart())) {
                    String username = args[0].getStringValue();
                    String groupName = args[1].getStringValue();
                    if (!securityManager.hasAccount(username)) {
                        throw new XPathException("The user account with username " + username + " does not exist.");
                    }
                    if (!securityManager.hasGroup(groupName)) {
                        throw new XPathException("The user group with name " + groupName + " does not exist.");
                    }
                    Group group = securityManager.getGroup(groupName);
                    if (!(this.isCalledAs(qnGetGroupMembers.getLocalPart()) || group.isManager(currentUser) || currentUser.hasDbaRole())) {
                        throw new XPathException("Only a Group Manager or DBA may modify the group or retrieve sensitive group information.");
                    }
                    Account account = securityManager.getAccount(username);
                    account.setPrimaryGroup(group);
                    securityManager.updateAccount(account);
                    break block19;
                }
                String groupName = args[0].getStringValue();
                if (!securityManager.hasGroup(groupName)) {
                    throw new XPathException("The user group with name " + groupName + " does not exist.");
                }
                Group group = securityManager.getGroup(groupName);
                if (!(this.isCalledAs(qnGetGroupMembers.getLocalPart()) || group.isManager(currentUser) || currentUser.hasDbaRole())) {
                    throw new XPathException("Only a Group Manager or DBA may modify the group or retrieve sensitive group information.");
                }
                if (this.isCalledAs(qnAddGroupMember.getLocalPart())) {
                    List<Account> users = this.getUsers(securityManager, args[1]);
                    this.addGroupMembers(securityManager, group, users);
                    break block19;
                }
                if (this.isCalledAs(qnRemoveGroupMember.getLocalPart())) {
                    List<Account> users = this.getUsers(securityManager, args[1]);
                    this.removeGroupMembers(securityManager, group, users);
                    break block19;
                }
                if (this.isCalledAs(qnGetGroupMembers.getLocalPart())) {
                    List<String> groupMembers = securityManager.findAllGroupMembers(groupName);
                    ValueSequence seq = new ValueSequence();
                    for (String groupMember : groupMembers) {
                        seq.add(new StringValue(groupMember));
                    }
                    result = seq;
                    break block19;
                }
                if (this.isCalledAs(qnAddGroupManager.getLocalPart())) {
                    List<Account> users = this.getUsers(securityManager, args[1]);
                    this.addGroupManagers(securityManager, group, users);
                    break block19;
                }
                if (this.isCalledAs(qnRemoveGroupManager.getLocalPart())) {
                    List<Account> users = this.getUsers(securityManager, args[1]);
                    this.removeGroupManagers(securityManager, group, users);
                    break block19;
                }
                if (this.isCalledAs(qnGetGroupManagers.getLocalPart())) {
                    ValueSequence seq = new ValueSequence();
                    for (Account groupManager : group.getManagers()) {
                        seq.add(new StringValue(groupManager.getName()));
                    }
                    result = seq;
                    break block19;
                }
                throw new XPathException("Unknown function call: " + this.getSignature());
            }
            catch (PermissionDeniedException pde) {
                throw new XPathException((Expression)this, (Throwable)pde);
            }
            catch (EXistException ee) {
                throw new XPathException((Expression)this, (Throwable)ee);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGroupMembers(SecurityManager securityManager, Group group, List<Account> accounts) throws PermissionDeniedException, EXistException {
        for (Account account : accounts) {
            try {
                this.context.getBroker().pushSubject(securityManager.getSystemSubject());
                account.addGroup(group);
                securityManager.updateAccount(account);
            }
            finally {
                this.context.getBroker().popSubject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGroupMembers(SecurityManager securityManager, Group group, List<Account> accounts) throws PermissionDeniedException, EXistException {
        for (Account account : accounts) {
            try {
                this.context.getBroker().pushSubject(securityManager.getSystemSubject());
                account.remGroup(group.getName());
                securityManager.updateAccount(account);
            }
            finally {
                this.context.getBroker().popSubject();
            }
        }
    }

    private void addGroupManagers(SecurityManager securityManager, Group group, List<Account> accounts) throws PermissionDeniedException, EXistException {
        group.addManagers(accounts);
        securityManager.updateGroup(group);
    }

    private void removeGroupManagers(SecurityManager securityManager, Group group, List<Account> accounts) throws PermissionDeniedException, EXistException {
        for (Account account : accounts) {
            group.removeManager(account);
        }
        securityManager.updateGroup(group);
    }

    private List<Account> getUsers(SecurityManager securityManager, Sequence seq) throws XPathException {
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (int i = 0; i < seq.getItemCount(); ++i) {
            String user = seq.itemAt(i).toString();
            Account account = securityManager.getAccount(user);
            if (account == null) {
                throw new XPathException("The user account '" + user + "' does not exist!");
            }
            accounts.add(account);
        }
        return accounts;
    }
}

