/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.storage.BrokerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;

public class CountInstances
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(CountInstances.class);
    public static final FunctionSignature countInstancesMax = new FunctionSignature(new QName("count-instances-max", "http://exist-db.org/xquery/system", "system"), "Returns the maximum number of eXist instances.", FunctionSignature.NO_ARGS, new FunctionParameterSequenceType("result", 31, 2, "the count"));
    public static final FunctionSignature countInstancesActive = new FunctionSignature(new QName("count-instances-active", "http://exist-db.org/xquery/system", "system"), "Returns the number of eXist instances that are active.", FunctionSignature.NO_ARGS, new FunctionParameterSequenceType("result", 31, 2, "the count"));
    public static final FunctionSignature countInstancesAvailable = new FunctionSignature(new QName("count-instances-available", "http://exist-db.org/xquery/system", "system"), "Returns the number of eXist instances that are available.", FunctionSignature.NO_ARGS, new FunctionParameterSequenceType("result", 31, 2, "the count"));
    private BrokerPool bp = null;

    public CountInstances(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.bp = context.getBroker().getBrokerPool();
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        int count = 0;
        if (this.isCalledAs("count-instances-max")) {
            count = this.bp.getMax();
        } else if (this.isCalledAs("count-instances-active")) {
            count = this.bp.countActiveBrokers();
        } else if (this.isCalledAs("count-instances-available")) {
            count = this.bp.available();
        }
        return new IntegerValue(count, 31);
    }
}

