/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.SystemImport;
import org.exist.backup.restore.listener.AbstractRestoreListener;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FnImport
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FnImport.class);
    protected static final QName NAME = new QName("import", "http://exist-db.org/xquery/system", "system");
    protected static final String DESCRIPTION = "Restore the database or a section of the database (admin user only).";
    protected static final FunctionParameterSequenceType DIRorFILE = new FunctionParameterSequenceType("dir-or-file", 22, 2, "This is either a backup directory with the backup descriptor (__contents__.xml) or a backup ZIP file.");
    protected static final FunctionParameterSequenceType ADMIN_PASS = new FunctionParameterSequenceType("admin-pass", 22, 3, "The password for the admin user");
    protected static final FunctionParameterSequenceType NEW_ADMIN_PASS = new FunctionParameterSequenceType("new-admin-pass", 22, 3, "Set the admin password to this new password.");
    protected static final FunctionReturnSequenceType RETURN = new FunctionReturnSequenceType(-1, 2, "the import results");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(NAME, "Restore the database or a section of the database (admin user only).", new SequenceType[]{DIRorFILE, ADMIN_PASS, NEW_ADMIN_PASS}, RETURN), new FunctionSignature(new QName("import-silently", "http://exist-db.org/xquery/system", "system"), "Restore the database or a section of the database (admin user only). Messagers from exporter reroute to logs.", new SequenceType[]{DIRorFILE, ADMIN_PASS, NEW_ADMIN_PASS}, RETURN)};
    public static final QName IMPORT_ELEMENT = new QName("import", "http://exist-db.org/xquery/system", "system");

    public FnImport(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            throw new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to kill a running xquery");
        }
        String dirOrFile = args[0].getStringValue();
        String adminPass = null;
        if (args[1].hasOne()) {
            adminPass = args[1].getStringValue();
        }
        String adminPassAfter = null;
        if (args[2].hasOne()) {
            adminPassAfter = args[2].getStringValue();
        }
        MemTreeBuilder builder = null;
        if (NAME.equals(this.mySignature.getName())) {
            builder = this.context.getDocumentBuilder();
            builder.startDocument();
            builder.startElement(IMPORT_ELEMENT, null);
        }
        try {
            SystemImport restore = new SystemImport(this.context.getDatabase());
            XMLRestoreListener listener = new XMLRestoreListener(builder);
            restore.restore(listener, "admin", adminPass, adminPassAfter, Paths.get(dirOrFile, new String[0]), XmldbURI.EMBEDDED_SERVER_URI.toString());
        }
        catch (Exception e) {
            throw new XPathException((Expression)this, "restore failed with exception: " + e.getMessage(), (Throwable)e);
        }
        if (builder == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        builder.endElement();
        builder.endDocument();
        return (NodeValue)((Object)builder.getDocument().getDocumentElement());
    }

    private static class XMLRestoreListener
    extends AbstractRestoreListener {
        public static final QName COLLECTION_ELEMENT = new QName("collection", "http://exist-db.org/xquery/system", "system");
        public static final QName RESOURCE_ELEMENT = new QName("resource", "http://exist-db.org/xquery/system", "system");
        public static final QName INFO_ELEMENT = new QName("info", "http://exist-db.org/xquery/system", "system");
        public static final QName WARN_ELEMENT = new QName("warn", "http://exist-db.org/xquery/system", "system");
        public static final QName ERROR_ELEMENT = new QName("error", "http://exist-db.org/xquery/system", "system");
        private final MemTreeBuilder builder;

        private XMLRestoreListener(MemTreeBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void createCollection(String collection) {
            if (this.builder == null) {
                SystemImport.LOG.info("Create collection " + collection);
            } else {
                this.builder.startElement(COLLECTION_ELEMENT, null);
                this.builder.characters(collection);
                this.builder.endElement();
            }
        }

        @Override
        public void restored(String resource) {
            if (this.builder == null) {
                SystemImport.LOG.info("Restore resource " + resource);
            } else {
                this.builder.startElement(RESOURCE_ELEMENT, null);
                this.builder.characters(resource);
                this.builder.endElement();
            }
        }

        @Override
        public void info(String message) {
            if (this.builder == null) {
                SystemImport.LOG.info(message);
            } else {
                this.builder.startElement(INFO_ELEMENT, null);
                this.builder.characters(message);
                this.builder.endElement();
            }
        }

        @Override
        public void warn(String message) {
            super.warn(message);
            if (this.builder == null) {
                SystemImport.LOG.warn(message);
            } else {
                this.builder.startElement(WARN_ELEMENT, null);
                this.builder.characters(message);
                this.builder.endElement();
            }
        }

        @Override
        public void error(String message) {
            super.error(message);
            if (this.builder == null) {
                SystemImport.LOG.error(message);
            } else {
                this.builder.startElement(ERROR_ELEMENT, null);
                this.builder.characters(message);
                this.builder.endElement();
            }
        }
    }
}

