/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.InternalModule;
import org.exist.xquery.Module;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunctionAvailable
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunctionAvailable.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("function-available", "http://exist-db.org/xquery/system", "system"), "Returns whether a function is available.", new SequenceType[]{new FunctionParameterSequenceType("function-name", 24, 2, "The fully qualified name of the function"), new FunctionParameterSequenceType("arity", 31, 2, "The arity of the function")}, new FunctionReturnSequenceType(23, 2, "true() if the function exists, false() otherwise."));

    public FunctionAvailable(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        QName functionName = ((QNameValue)args[0].itemAt(0)).getQName();
        int arity = ((IntegerValue)args[1].itemAt(0)).getInt();
        Module module = this.context.getModule(functionName.getNamespaceURI());
        boolean found = false;
        if (module == null) {
            found = this.context.resolveFunction(functionName, arity) != null;
        } else if (module instanceof InternalModule) {
            found = ((InternalModule)module).getFunctionDef(functionName, arity) != null;
        } else if (module instanceof ExternalModule) {
            found = ((ExternalModule)module).getFunction(functionName, arity, this.context) != null;
        }
        return BooleanValue.valueOf(found);
    }
}

