/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.storage.BrokerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunctionTrace
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunctionTrace.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("trace", "http://exist-db.org/xquery/system", "system"), "Returns function call statistics gathered by the trace log.", null, new FunctionParameterSequenceType("call-statistics", -1, 2, "the call statistics gathered by the trace")), new FunctionSignature(new QName("enable-tracing", "http://exist-db.org/xquery/system", "system"), "Enable function tracing on the database instance.", new SequenceType[]{new FunctionParameterSequenceType("enable", 23, 2, "The boolean flag to enable/disable function tracing")}, new SequenceType(11, 1)), new FunctionSignature(new QName("enable-tracing", "http://exist-db.org/xquery/system", "system"), "Enable function tracing on the database instance.", new SequenceType[]{new FunctionParameterSequenceType("enable", 23, 2, "The enable boolean flag to enable/disable function tracing"), new FunctionParameterSequenceType("tracelog", 23, 2, "The tracelog boolean flag: if set to true, entering/exiting a function will be logged to the logger 'xquery.profiling'")}, new SequenceType(11, 1)), new FunctionSignature(new QName("tracing-enabled", "http://exist-db.org/xquery/system", "system"), "Returns true if function tracing is currently enabled on the database instance.", null, new FunctionParameterSequenceType("tracing-enabled", 23, 2, "true is tracing is enabled.")), new FunctionSignature(new QName("clear-trace", "http://exist-db.org/xquery/system", "system"), "Clear the global trace log.", null, new SequenceType(11, 1))};

    public FunctionTrace(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        logger.info("Entering system:" + this.getName().getLocalPart());
        if (this.isCalledAs("clear-trace")) {
            logger.info("Entering the system:clear-trace XQuery function");
            this.context.getBroker().getBrokerPool().getPerformanceStats().clear();
        } else if (this.isCalledAs("enable-tracing")) {
            logger.info("Entering the system:enable-tracing XQuery function");
            boolean enable = args[0].effectiveBooleanValue();
            this.context.getBroker().getBrokerPool().getPerformanceStats().setEnabled(enable);
            if (this.getArgumentCount() == 2) {
                if (args[1].effectiveBooleanValue()) {
                    this.context.getBroker().getConfiguration().setProperty("xquery.profiling.tracelog", Boolean.TRUE);
                } else {
                    this.context.getBroker().getConfiguration().setProperty("xquery.profiling.tracelog", Boolean.FALSE);
                }
            }
        } else {
            if (this.isCalledAs("tracing-enabled")) {
                logger.info("Entering the system:tracing-enabled XQuery function");
                logger.info("Exiting system:" + this.getName().getLocalPart());
                return BooleanValue.valueOf(this.context.getBroker().getBrokerPool().getPerformanceStats().isEnabled());
            }
            logger.info("Entering the system:trace XQuery function");
            this.context.getProfiler().reset();
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            builder.startDocument();
            BrokerPool brokerPool = this.context.getBroker().getBrokerPool();
            brokerPool.getPerformanceStats().toXML(builder);
            builder.endDocument();
            logger.info("Exiting system:" + this.getName().getLocalPart());
            return (NodeValue)((Object)builder.getDocument().getDocumentElement());
        }
        logger.info("Exiting system:" + this.getName().getLocalPart());
        return Sequence.EMPTY_SEQUENCE;
    }
}

