/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;

public class GetRunningXQueries
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetRunningXQueries.class);
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/system";
    static final String PREFIX = "system";
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-running-xqueries", "http://exist-db.org/xquery/system", "system"), "Get a list of running XQueries (dba role only).", null, new FunctionReturnSequenceType(11, 2, "a node containing the list of running XQueries"));

    public GetRunningXQueries(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to get the list of running xqueries");
            logger.error("Invalid user system:get-scheduled-xqueries", (Throwable)xPathException);
            throw xPathException;
        }
        return this.getRunningXQueries();
    }

    private Sequence getRunningXQueries() throws XPathException {
        XQueryWatchDog[] watchdogs;
        NodeValue xmlResponse = null;
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("xqueries", NAMESPACE_URI, PREFIX), null);
        for (XQueryWatchDog watchdog : watchdogs = this.getContext().getBroker().getBrokerPool().getProcessMonitor().getRunningXQueries()) {
            XQueryContext context = watchdog.getContext();
            this.getRunningXQuery(builder, context, watchdog);
        }
        builder.endElement();
        xmlResponse = (NodeValue)((Object)builder.getDocument().getDocumentElement());
        return xmlResponse;
    }

    private void getRunningXQuery(MemTreeBuilder builder, XQueryContext context, XQueryWatchDog watchdog) throws XPathException {
        builder.startElement(new QName("xquery", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("id", null, null), "" + context.hashCode());
        builder.addAttribute(new QName("sourceType", null, null), context.getSource().type());
        builder.addAttribute(new QName("started", null, null), new DateTimeValue(new Date(watchdog.getStartTime())).getStringValue());
        builder.addAttribute(new QName("terminating", null, null), watchdog.isTerminating() ? "true" : "false");
        builder.startElement(new QName("sourceKey", NAMESPACE_URI, PREFIX), null);
        builder.characters(context.getSource().path());
        builder.endElement();
        builder.startElement(new QName("xqueryExpression", NAMESPACE_URI, PREFIX), null);
        builder.characters(context.getRootExpression().toString());
        builder.endElement();
        builder.endElement();
    }
}

