/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class KillRunningXQuery
extends BasicFunction {
    protected static final FunctionParameterSequenceType WAIT_TIME_PARAM = new FunctionParameterSequenceType("wait-time", 37, 2, "The wait time in milliseconds before terminating the XQuery");
    protected static final FunctionParameterSequenceType XQUERY_ID_PARAM = new FunctionParameterSequenceType("xquery-id", 31, 2, "The XQuery ID obtained from get-running-xqueries()");
    protected static final Logger logger = LogManager.getLogger(KillRunningXQuery.class);
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/system";
    static final String PREFIX = "system";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("kill-running-xquery", "http://exist-db.org/xquery/system", "system"), "Kill a running XQuey (dba role only).", new SequenceType[]{XQUERY_ID_PARAM}, new SequenceType(11, 1)), new FunctionSignature(new QName("kill-running-xquery", "http://exist-db.org/xquery/system", "system"), "Kill a running XQuey (dba role only).", new SequenceType[]{XQUERY_ID_PARAM, WAIT_TIME_PARAM}, new SequenceType(11, 1))};

    public KillRunningXQuery(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            throw new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to kill a running xquery");
        }
        this.killXQuery(args);
        return Sequence.EMPTY_SEQUENCE;
    }

    private void killXQuery(Sequence[] args) throws XPathException {
        int id = 0;
        long waittime = 0L;
        if (args.length == 1 && !args[0].isEmpty()) {
            id = ((NumericValue)args[0].itemAt(0)).getInt();
        }
        if (args.length == 2 && !args[1].isEmpty()) {
            waittime = ((NumericValue)args[1].itemAt(0)).getLong();
        }
        if (id != 0) {
            XQueryWatchDog[] watchdogs = this.getContext().getBroker().getBrokerPool().getProcessMonitor().getRunningXQueries();
            for (int i = 0; i < watchdogs.length; ++i) {
                XQueryContext context = watchdogs[i].getContext();
                if (id != context.hashCode()) continue;
                if (watchdogs[i].isTerminating()) break;
                watchdogs[i].kill(waittime);
                break;
            }
        }
    }
}

