/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.exist.start.LatestFileResolver;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XQueryContext;

public abstract class LibFunction
extends BasicFunction {
    private static final String LIB_WEBINF = "WEB-INF/lib/";
    private static final String[] LIB = new String[]{"./lib/core", "./lib/optional", "./lib/extensions", "./lib/user", "."};
    private static Map<String, Path> allFiles = new HashMap<String, Path>();
    private static LatestFileResolver libFileResolver = new LatestFileResolver();
    private Stream<Path> libFolders;

    public LibFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.libFolders = context.getBroker().getConfiguration().getExistHome().map(this::libFolders).orElse(Stream.empty());
    }

    private Stream<Path> libFolders(Path contextRoot) {
        if (this.isInWarFile(contextRoot)) {
            return Stream.of(contextRoot.resolve(LIB_WEBINF));
        }
        return Arrays.stream(LIB).map(contextRoot::resolve);
    }

    private boolean isInWarFile(Path existHome) {
        return !Files.isDirectory(existHome.resolve(LIB[0]), new LinkOption[0]);
    }

    private Optional<Path> getLib(Path folder, String libFileBaseName) {
        String fileToFind = folder.toAbsolutePath().resolve(libFileBaseName).toString();
        String resolvedFile = libFileResolver.getResolvedFileName(fileToFind);
        return Optional.of(Paths.get(resolvedFile, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    protected Path getLib(String key) {
        Path retVal = allFiles.get(key);
        if (allFiles.keySet().contains(key)) {
            return retVal;
        }
        Optional<Optional> libVal = this.libFolders.map(libFolder -> this.getLib((Path)libFolder, key)).filter(Optional::isPresent).findFirst();
        if (libVal.isPresent() && libVal.get().isPresent()) {
            retVal = (Path)libVal.get().get();
        }
        allFiles.put(key, retVal);
        return retVal;
    }
}

