/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.system;

import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.restore.listener.AbstractRestoreListener;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Restore
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Restore.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("restore", "http://exist-db.org/xquery/system", "system"), "Restore the database or a section of the database (admin user only).", new SequenceType[]{new FunctionParameterSequenceType("dir-or-file", 22, 2, "This is either a backup directory with the backup descriptor (__contents__.xml) or a backup ZIP file."), new FunctionParameterSequenceType("admin-pass", 22, 3, "The password for the admin user"), new FunctionParameterSequenceType("new-admin-pass", 22, 3, "Set the admin password to this new password.")}, new FunctionReturnSequenceType(-1, 2, "the restore results"));
    public static final QName RESTORE_ELEMENT = new QName("restore", "http://exist-db.org/xquery/system", "system");

    public Restore(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String dirOrFile = args[0].getStringValue();
        String adminPass = null;
        if (args[1].hasOne()) {
            adminPass = args[1].getStringValue();
        }
        String adminPassAfter = null;
        if (args[2].hasOne()) {
            adminPassAfter = args[2].getStringValue();
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(RESTORE_ELEMENT, null);
        try {
            org.exist.backup.Restore restore = new org.exist.backup.Restore();
            XMLRestoreListener listener = new XMLRestoreListener(builder);
            restore.restore(listener, "admin", adminPass, adminPassAfter, Paths.get(dirOrFile, new String[0]), XmldbURI.EMBEDDED_SERVER_URI.toString());
        }
        catch (Exception e) {
            throw new XPathException((Expression)this, "restore failed with exception: " + e.getMessage(), (Throwable)e);
        }
        builder.endElement();
        builder.endDocument();
        return (NodeValue)((Object)builder.getDocument().getDocumentElement());
    }

    private static class XMLRestoreListener
    extends AbstractRestoreListener {
        public static final QName COLLECTION_ELEMENT = new QName("collection", "http://exist-db.org/xquery/system", "system");
        public static final QName RESOURCE_ELEMENT = new QName("resource", "http://exist-db.org/xquery/system", "system");
        public static final QName INFO_ELEMENT = new QName("info", "http://exist-db.org/xquery/system", "system");
        public static final QName WARN_ELEMENT = new QName("warn", "http://exist-db.org/xquery/system", "system");
        public static final QName ERROR_ELEMENT = new QName("error", "http://exist-db.org/xquery/system", "system");
        private final MemTreeBuilder builder;

        private XMLRestoreListener(MemTreeBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void createCollection(String collection) {
            this.builder.startElement(COLLECTION_ELEMENT, null);
            this.builder.characters(collection);
            this.builder.endElement();
        }

        @Override
        public void restored(String resource) {
            this.builder.startElement(RESOURCE_ELEMENT, null);
            this.builder.characters(resource);
            this.builder.endElement();
        }

        @Override
        public void info(String message) {
            this.builder.startElement(INFO_ELEMENT, null);
            this.builder.characters(message);
            this.builder.endElement();
        }

        @Override
        public void warn(String message) {
            super.warn(message);
            this.builder.startElement(WARN_ELEMENT, null);
            this.builder.characters(message);
            this.builder.endElement();
        }

        @Override
        public void error(String message) {
            super.error(message);
            this.builder.startElement(ERROR_ELEMENT, null);
            this.builder.characters(message);
            this.builder.endElement();
        }
    }
}

