/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.transform;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.persistent.NodeProxy;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.numbering.NodeId;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.serializers.XIncludeFilter;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.ReceiverToSAX;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;
import org.exist.xslt.Stylesheet;
import org.exist.xslt.TemplatesFactory;
import org.exist.xslt.Transformer;
import org.exist.xslt.XSLTErrorsListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Transform
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The stylesheet is specified in the second argument. This should either be an URI or a node. If it is an URI, it can either point to an external location or to an XSL stored in the db by using the 'xmldb:' scheme. Stylesheets are cached unless they were just created from an XML fragment and not from a complete document. Stylesheet parameters may be passed in the third argument using an XML fragment with the following structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>. There are two special parameters named \"exist:stop-on-warn\" and \"exist:stop-on-error\". If set to value \"yes\", eXist will generate an XQuery error if the XSL processor reports a warning or error.", new SequenceType[]{new FunctionParameterSequenceType("node-tree", -1, 7, "The source-document (node tree)"), new FunctionParameterSequenceType("stylesheet", 11, 2, "The XSL stylesheet"), new FunctionParameterSequenceType("parameters", -1, 3, "The transformer parameters")}, new FunctionReturnSequenceType(-1, 3, "the transformed result (node tree)")), new FunctionSignature(new QName("transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The stylesheet is specified in the second argument. This should either be an URI or a node. If it is an URI, it can either point to an external location or to an XSL stored in the db by using the 'xmldb:' scheme. Stylesheets are cached unless they were just created from an XML fragment and not from a complete document. Stylesheet parameters may be passed in the third argument using an XML fragment with the following structure: <parameters><param name=\"param-name\" value=\"param-value\"/></parameters>. There are two special parameters named \"exist:stop-on-warn\" and \"exist:stop-on-error\". If set to value \"yes\", eXist will generate an XQuery error if the XSL processor reports a warning or error. The fourth argument specifies attributes to be set on the used Java TransformerFactory with the following structure: <attributes><attr name=\"attr-name\" value=\"attr-value\"/></attributes>.  The fifth argument specifies serialization options in the same way as if they were passed to \"declare option exist:serialize\" expression. An additional serialization option, \"xinclude-path\", is supported, which specifies a base path against which xincludes will be expanded (if there are xincludes in the document). A relative path will be relative to the current module load path.", new SequenceType[]{new FunctionParameterSequenceType("node-tree", -1, 7, "The source-document (node tree)"), new FunctionParameterSequenceType("stylesheet", 11, 2, "The XSL stylesheet"), new FunctionParameterSequenceType("parameters", -1, 3, "The transformer parameters"), new FunctionParameterSequenceType("attributes", -1, 3, "Attributes to pass to the transformation factory"), new FunctionParameterSequenceType("serialization-options", 22, 3, "The serialization options")}, new FunctionReturnSequenceType(-1, 3, "the transformed result (node tree)")), new FunctionSignature(new QName("stream-transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The parameters are the same as for the transform function. stream-transform can only be used within a servlet context. Instead of returning the transformed document fragment, it directly streams its output to the servlet's output stream. It should thus be the last statement in the XQuery.", new SequenceType[]{new FunctionParameterSequenceType("node-tree", -1, 7, "The source-document (node tree)"), new FunctionParameterSequenceType("stylesheet", 11, 2, "The XSL stylesheet"), new FunctionParameterSequenceType("parameters", -1, 3, "The transformer parameters")}, new SequenceType(11, 1)), new FunctionSignature(new QName("stream-transform", "http://exist-db.org/xquery/transform", "transform"), "Applies an XSL stylesheet to the node tree passed as first argument. The parameters are the same as for the transform function. stream-transform can only be used within a servlet context. Instead of returning the transformed document fragment, it directly streams its output to the servlet's output stream. It should thus be the last statement in the XQuery.", new SequenceType[]{new FunctionParameterSequenceType("node-tree", -1, 7, "The source-document (node tree)"), new FunctionParameterSequenceType("stylesheet", 11, 2, "The XSL stylesheet"), new FunctionParameterSequenceType("parameters", -1, 3, "The transformer parameters"), new FunctionParameterSequenceType("attributes", -1, 3, "Attributes to pass to the transformation factory"), new FunctionParameterSequenceType("serialization-options", 22, 3, "The serialization options")}, new SequenceType(11, 1))};
    private static final Logger logger = LogManager.getLogger(Transform.class);
    private boolean stopOnError = true;
    private boolean stopOnWarn = false;

    public Transform(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Node options;
        Properties attributes = new Properties();
        Properties serializationProps = new Properties();
        Properties stylesheetParams = new Properties();
        Sequence inputNode = args[0];
        Item stylesheetItem = args[1].itemAt(0);
        Node node = options = args[2].isEmpty() ? null : ((NodeValue)args[2].itemAt(0)).getNode();
        if (options != null) {
            stylesheetParams.putAll((Map<?, ?>)this.parseParameters(options));
        }
        if (this.getArgumentCount() >= 4) {
            Sequence attrs = args[3];
            attributes.putAll((Map<?, ?>)this.extractAttributes(attrs));
        }
        if (this.getArgumentCount() >= 5) {
            Sequence serOpts = args[4];
            serializationProps.putAll((Map<?, ?>)this.extractSerializationProperties(serOpts));
        } else {
            this.context.checkOptions(serializationProps);
        }
        boolean expandXIncludes = "yes".equals(serializationProps.getProperty("expand-xincludes", "yes"));
        XSLTErrorsListener<XPathException> errorListener = new XSLTErrorsListener<XPathException>(this.stopOnError, this.stopOnWarn){

            @Override
            protected void raiseError(String error, Exception ex) throws XPathException {
                throw new XPathException((Expression)Transform.this, error, (Throwable)ex);
            }
        };
        TransformerHandler handler = this.createHandler(stylesheetItem, stylesheetParams, attributes, errorListener);
        if (this.isCalledAs("transform")) {
            javax.xml.transform.Transformer transformer = handler.getTransformer();
            if ("org.exist.xslt.TransformerImpl".equals(transformer.getClass().getName())) {
                this.context.pushDocumentContext();
                Sequence seq = ((Transformer)transformer).transform(args[0]);
                this.context.popDocumentContext();
                return seq;
            }
            ValueSequence seq = new ValueSequence();
            this.context.pushDocumentContext();
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            DocumentBuilderReceiver builderReceiver = new DocumentBuilderReceiver(builder, true);
            SAXResult result = new SAXResult(builderReceiver);
            result.setLexicalHandler(builderReceiver);
            handler.setResult(result);
            ReceiverToSAX receiver = new ReceiverToSAX(handler);
            Serializer serializer = this.context.getBroker().getSerializer();
            serializer.reset();
            try {
                serializer.setProperties(serializationProps);
                serializer.setReceiver(receiver, true);
                if (expandXIncludes) {
                    String xiPath = serializationProps.getProperty("xinclude-path");
                    if (xiPath != null) {
                        Path f = Paths.get(xiPath, new String[0]).normalize();
                        if (!f.isAbsolute()) {
                            xiPath = Paths.get(this.context.getModuleLoadPath(), xiPath).normalize().toAbsolutePath().toString();
                        }
                    } else {
                        xiPath = this.context.getModuleLoadPath();
                    }
                    serializer.getXIncludeFilter().setModuleLoadPath(xiPath);
                }
                serializer.toSAX(inputNode, 1, inputNode.getItemCount(), false, false, 0L, 0L);
            }
            catch (Exception e) {
                throw new XPathException((Expression)this, "Exception while transforming node: " + e.getMessage(), (Throwable)e);
            }
            errorListener.checkForErrors();
            for (Node next = builder.getDocument().getFirstChild(); next != null; next = next.getNextSibling()) {
                seq.add((NodeValue)((Object)next));
            }
            this.context.popDocumentContext();
            return seq;
        }
        ResponseModule myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response");
        Variable respVar = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
        if (respVar == null) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "No response object found in the current XQuery context.");
        }
        if (respVar.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue respValue = (JavaObjectValue)respVar.getValue().itemAt(0);
        if (!"org.exist.http.servlets.HttpResponseWrapper".equals(respValue.getObject().getClass().getName())) {
            throw new XPathException((Expression)this, ErrorCodes.XPDY0002, signatures[1] + " can only be used within the EXistServlet or XQueryServlet");
        }
        ResponseWrapper response = (ResponseWrapper)respValue.getObject();
        String mediaType = handler.getTransformer().getOutputProperty("media-type");
        String encoding = handler.getTransformer().getOutputProperty("encoding");
        if (mediaType != null) {
            if (encoding == null) {
                response.setContentType(mediaType);
            } else {
                response.setContentType(mediaType + "; charset=" + encoding);
            }
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(response.getOutputStream());
            StreamResult result = new StreamResult(os);
            handler.setResult(result);
            Serializer serializer = this.context.getBroker().getSerializer();
            serializer.reset();
            Receiver receiver = new ReceiverToSAX(handler);
            try {
                serializer.setProperties(serializationProps);
                if (expandXIncludes) {
                    XIncludeFilter xinclude = new XIncludeFilter(serializer, receiver);
                    String xiPath = serializationProps.getProperty("xinclude-path");
                    if (xiPath != null) {
                        Path f = Paths.get(xiPath, new String[0]).normalize();
                        if (!f.isAbsolute()) {
                            xiPath = Paths.get(this.context.getModuleLoadPath(), xiPath).normalize().toAbsolutePath().toString();
                        }
                    } else {
                        xiPath = this.context.getModuleLoadPath();
                    }
                    xinclude.setModuleLoadPath(xiPath);
                    receiver = xinclude;
                }
                serializer.setReceiver(receiver);
                serializer.toSAX(inputNode);
            }
            catch (Exception e) {
                throw new XPathException((Expression)this, "Exception while transforming node: " + e.getMessage(), (Throwable)e);
            }
            errorListener.checkForErrors();
            ((OutputStream)os).close();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "IO exception while transforming node: " + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    private TransformerHandler createHandler(Item stylesheetItem, Properties options, Properties attributes, XSLTErrorsListener<XPathException> errorListener) throws TransformerFactoryConfigurationError, XPathException {
        TransformerHandler handler;
        boolean useCache = true;
        Object property = this.context.getBroker().getConfiguration().getProperty("transformer.caching");
        if (property != null) {
            useCache = (Boolean)property;
        }
        try {
            Stylesheet stylesheet = null;
            if (Type.subTypeOf(stylesheetItem.getType(), -1)) {
                NodeProxy root;
                NodeValue stylesheetNode = (NodeValue)stylesheetItem;
                if (stylesheetNode.getImplementationType() == 1 && ((root = (NodeProxy)stylesheetNode).getNodeId() == NodeId.DOCUMENT_NODE || root.getNodeId().getTreeLevel() == 1)) {
                    String uri = "xmldb:" + this.context.getBroker().getBrokerPool().getId() + "://" + root.getOwnerDocument().getURI();
                    stylesheet = TemplatesFactory.stylesheet(uri, this.context.getModuleLoadPath(), attributes, useCache);
                }
                if (stylesheet == null) {
                    stylesheet = TemplatesFactory.stylesheet(this.getContext().getBroker(), stylesheetNode, this.context.getModuleLoadPath());
                }
            } else {
                String baseUri = this.context.getModuleLoadPath();
                if (stylesheetItem instanceof Document) {
                    baseUri = ((Document)((Object)stylesheetItem)).getDocumentURI();
                    baseUri = baseUri == null ? this.context.getModuleLoadPath() : baseUri.substring(0, baseUri.lastIndexOf(47));
                }
                String uri = stylesheetItem.getStringValue();
                stylesheet = TemplatesFactory.stylesheet(uri, baseUri, attributes, useCache);
            }
            handler = stylesheet.newTransformerHandler(this.getContext().getBroker(), errorListener);
            if (options != null) {
                this.setParameters(options, handler.getTransformer());
            }
        }
        catch (Exception e) {
            if (e instanceof XPathException) {
                throw (XPathException)e;
            }
            throw new XPathException((Expression)this, "Unable to set up transformer: " + e.getMessage(), (Throwable)e);
        }
        return handler;
    }

    private Properties extractSerializationProperties(Sequence serOpts) throws XPathException {
        Properties serializationProps = new Properties();
        if (!serOpts.isEmpty()) {
            String[] contents;
            for (String content : contents = Option.tokenize(serOpts.getStringValue())) {
                String[] pair = Option.parseKeyValuePair(content);
                if (pair == null) {
                    throw new XPathException((Expression)this, "Found invalid serialization option: " + content);
                }
                logger.info("Setting serialization property: " + pair[0] + " = " + pair[1]);
                serializationProps.setProperty(pair[0], pair[1]);
            }
        }
        return serializationProps;
    }

    private Properties extractAttributes(Sequence attrs) throws XPathException {
        if (attrs.isEmpty()) {
            return new Properties();
        }
        return this.parseElementParam(((NodeValue)attrs.itemAt(0)).getNode(), "attributes", "attr");
    }

    private Properties parseParameters(Node options) throws XPathException {
        return this.parseElementParam(options, "parameters", "param");
    }

    private Properties parseElementParam(Node elementParam, String container, String param) throws XPathException {
        Properties props = new Properties();
        if (elementParam.getNodeType() == 1 && elementParam.getLocalName().equals(container)) {
            for (Node child = elementParam.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getLocalName().equals(param)) continue;
                Element elem = (Element)child;
                String name = elem.getAttribute("name");
                String value = elem.getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException((Expression)this, "Name or value attribute missing");
                }
                if ("exist:stop-on-warn".equals(name)) {
                    this.stopOnWarn = "yes".equals(value);
                    continue;
                }
                if ("exist:stop-on-error".equals(name)) {
                    this.stopOnError = "yes".equals(value);
                    continue;
                }
                props.setProperty(name, value);
            }
        }
        return props;
    }

    private void setParameters(Properties parameters, javax.xml.transform.Transformer handler) {
        for (Object o : parameters.keySet()) {
            String key = (String)o;
            handler.setParameter(key, parameters.getProperty(key));
        }
    }
}

