/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class BaseConverter
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(BaseConverter.class);
    private static final FunctionParameterSequenceType number_param = new FunctionParameterSequenceType("number", 11, 2, "The number to convert");
    private static final FunctionParameterSequenceType int_param = new FunctionParameterSequenceType("number", 31, 2, "The number to convert");
    private static final FunctionParameterSequenceType base_param = new FunctionParameterSequenceType("base", 31, 2, "The base of $number");
    private static final FunctionReturnSequenceType int_result = new FunctionReturnSequenceType(31, 2, "the xs:integer representation of $number in base $base");
    private static final FunctionReturnSequenceType string_result = new FunctionReturnSequenceType(22, 2, "the xs:string representation of $number in base $base");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("base-to-integer", "http://exist-db.org/xquery/util", "util"), "Converts the number $number from base $base to xs:integer.", new SequenceType[]{number_param, base_param}, int_result), new FunctionSignature(new QName("integer-to-base", "http://exist-db.org/xquery/util", "util"), "Converts the xs:integer $number (unsigned) into base $base as xs:string. Bases 2, 8, and 16 are supported.", new SequenceType[]{int_param, base_param}, string_result)};

    public BaseConverter(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String stringValue;
        String number = args[0].itemAt(0).getStringValue();
        int intBase = ((IntegerValue)args[1].itemAt(0)).getInt();
        if (this.isCalledAs("base-to-integer")) {
            int intValue = Integer.parseInt(number, intBase);
            return new IntegerValue(intValue);
        }
        switch (Base.getBase(intBase)) {
            case BINARY: {
                stringValue = Integer.toBinaryString(Integer.parseInt(number));
                break;
            }
            case OCTAL: {
                stringValue = Integer.toOctalString(Integer.parseInt(number));
                break;
            }
            case HEXADECIMAL: {
                stringValue = Integer.toHexString(Integer.parseInt(number));
                break;
            }
            default: {
                logger.error("Unhandled base for conversion target in integer-to-base().");
                throw new XPathException("Unhandled base for conversion target in integer-to-base().");
            }
        }
        return new StringValue(stringValue);
    }

    public static enum Base {
        BINARY(2),
        OCTAL(8),
        DECIMAL(10),
        HEXADECIMAL(16);

        public final int base;

        private Base(int base) {
            this.base = base;
        }

        public static Base getBase(int otherBase) {
            for (Base b : Base.values()) {
                if (otherBase != b.base) continue;
                return b;
            }
            return DECIMAL;
        }
    }
}

