/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Base64BinaryDocument;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class BinaryDoc
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(BinaryDoc.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("binary-doc", "http://exist-db.org/xquery/util", "util"), "Retrieves the binary resource and returns its contents as a value of type xs:base64Binary. An empty sequence is returned if the resource could not be found or $binary-resource was empty.", new SequenceType[]{new FunctionParameterSequenceType("binary-resource", 22, 3, "The path to the binary resource")}, new FunctionReturnSequenceType(26, 3, "the binary document")), new FunctionSignature(new QName("binary-doc-available", "http://exist-db.org/xquery/util", "util"), "Checks if the binary resource identified by $binary-resource is available.", new SequenceType[]{new FunctionParameterSequenceType("binary-resource", 22, 3, "The path to the binary resource")}, new FunctionReturnSequenceType(23, 2, "true if the binary document is available")), new FunctionSignature(new QName("is-binary-doc", "http://exist-db.org/xquery/util", "util"), "Checks if the resource identified by $binary-resource is a binary resource.", new SequenceType[]{new FunctionParameterSequenceType("binary-resource", 22, 3, "The path to the binary resource")}, new FunctionReturnSequenceType(23, 2, "true if the resource is a binary document"))};

    public BinaryDoc(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence defaultReturn;
        Sequence sequence = defaultReturn = this.isCalledAs("binary-doc") ? Sequence.EMPTY_SEQUENCE : BooleanValue.FALSE;
        if (args[0].isEmpty()) {
            return defaultReturn;
        }
        String path = args[0].getStringValue();
        DocumentImpl doc = null;
        try {
            doc = this.context.getBroker().getXMLResource(XmldbURI.xmldbUriFor(path), Lock.LockMode.READ_LOCK);
            if (doc == null) {
                Sequence sequence2 = defaultReturn;
                return sequence2;
            }
            if (doc.getResourceType() != 1) {
                Sequence sequence3 = defaultReturn;
                return sequence3;
            }
            if (this.isCalledAs("binary-doc")) {
                BinaryDocument bin = (BinaryDocument)doc;
                InputStream is = this.context.getBroker().getBinaryResource(bin);
                Base64BinaryDocument b64doc = Base64BinaryDocument.getInstance(this.context, is);
                b64doc.setUrl(path);
                Base64BinaryDocument base64BinaryDocument = b64doc;
                return base64BinaryDocument;
            }
            BooleanValue bin = BooleanValue.TRUE;
            return bin;
        }
        catch (URISyntaxException e) {
            logger.error("Invalid resource URI", (Throwable)e);
            throw new XPathException((Expression)this, "Invalid resource uri", (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            logger.info(path + ": permission denied to read resource", (Throwable)e);
            throw new XPathException((Expression)this, path + ": permission denied to read resource");
        }
        catch (IOException e) {
            logger.error(path + ": I/O error while reading resource", (Throwable)e);
            throw new XPathException((Expression)this, path + ": I/O error while reading resource", (Throwable)e);
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
    }
}

