/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class BinaryToString
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(BinaryToString.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("binary-to-string", "http://exist-db.org/xquery/util", "util"), "Returns the contents of a binary resource as an xs:string value. The binary data is transformed into a Java string using the encoding specified in the optional second argument or the default of UTF-8.", new SequenceType[]{new FunctionParameterSequenceType("binary-resource", 26, 3, "The binary resource")}, new FunctionReturnSequenceType(22, 3, "the string containing the encoded binary resource")), new FunctionSignature(new QName("binary-to-string", "http://exist-db.org/xquery/util", "util"), "Returns the contents of a binary resource as an xs:string value. The binary data is transformed into a Java string using the encoding specified in the optional second argument or the default of UTF-8.", new SequenceType[]{new FunctionParameterSequenceType("binary-resource", 26, 3, "The binary resource"), new FunctionParameterSequenceType("encoding", 22, 2, "The encoding type.  i.e. 'UTF-8'")}, new FunctionReturnSequenceType(22, 3, "the string containing the encoded binary resource")), new FunctionSignature(new QName("string-to-binary", "http://exist-db.org/xquery/util", "util"), "Returns the contents of a string as an base64binary value. The string data is transformed into a binary using the encoding specified in the optional second argument or the default of UTF-8.", new SequenceType[]{new FunctionParameterSequenceType("encoded-string", 22, 3, "The string containing the encoded binary resource")}, new FunctionReturnSequenceType(26, 3, "the binary resource")), new FunctionSignature(new QName("string-to-binary", "http://exist-db.org/xquery/util", "util"), "Returns the contents of a string as a base64binary value. The string data is transformed into a binary using the encoding specified in the optional second argument or the default of UTF-8.", new SequenceType[]{new FunctionParameterSequenceType("encoded-string", 22, 3, "The string containing the encoded binary resource"), new FunctionParameterSequenceType("encoding", 22, 2, "the encoding type.  i.e. 'UTF-8'")}, new FunctionReturnSequenceType(26, 3, "the binary resource"))};

    public BinaryToString(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String encoding = "UTF-8";
        if (args.length == 2) {
            encoding = args[1].getStringValue();
        }
        if (this.isCalledAs("binary-to-string")) {
            return this.binaryToString((BinaryValue)args[0].itemAt(0), encoding);
        }
        return this.stringToBinary(args[0].getStringValue(), encoding);
    }

    protected StringValue binaryToString(BinaryValue binary, String encoding) throws XPathException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            binary.streamBinaryTo((OutputStream)os);
            StringValue stringValue = new StringValue(new String(os.toByteArray(), encoding));
            return stringValue;
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, (Throwable)ioe);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected BinaryValue stringToBinary(String str, String encoding) throws XPathException {
        try {
            return BinaryValueFromInputStream.getInstance(this.context, new Base64BinaryValueType(), new ByteArrayInputStream(str.getBytes(encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException((Expression)this, "Unsupported encoding: " + encoding);
        }
    }
}

