/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import com.ibm.icu.text.Collator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class Collations
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Collations.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("collations", "http://exist-db.org/xquery/util", "util"), "Returns a sequence of strings containing all collation locales that might be specified in the '?lang=' parameter of a collation URI.", FunctionSignature.NO_ARGS, new FunctionReturnSequenceType(22, 7, "the sequence of strings containing all collation locales that might be specified in the '?lang=' parameter of a collation URI."));

    public Collations(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Locale[] locales;
        ValueSequence result = new ValueSequence();
        for (Locale locale : locales = Collator.getAvailableLocales()) {
            String language = locale.getLanguage();
            if (locale.getCountry().length() > 0) {
                language = language + '-' + locale.getCountry();
            }
            result.add(new StringValue(language));
        }
        return result;
    }
}

