/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.EmptySequence;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class Compile
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Compile.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("compile", "http://exist-db.org/xquery/util", "util"), "Compiles the XQuery expression given in parameter $expression. Returns an empty string if no errors were found, a description of the error otherwise.", new SequenceType[]{new FunctionParameterSequenceType("expression", 22, 2, "The XPath/XQuery expression.")}, new FunctionReturnSequenceType(22, 2, "the results of the expression")), new FunctionSignature(new QName("compile", "http://exist-db.org/xquery/util", "util"), "Compiles the XQuery expression given in parameter $expression. Returns an empty string if no errors were found, a description of the error otherwise.", new SequenceType[]{new FunctionParameterSequenceType("expression", 22, 2, "The XPath/XQuery expression."), new FunctionParameterSequenceType("module-load-path", 22, 2, "The module load path. Imports will be resolved relative to this. Use xmldb:exist:///db if your modules are stored in db.")}, new FunctionReturnSequenceType(22, 2, "the results of the expression")), new FunctionSignature(new QName("compile-query", "http://exist-db.org/xquery/util", "util"), "Compiles the XQuery expression given in parameter $expression. Returns an XML fragment which describes any errors found. If the query could be compiled successfully, a fragment <info result=\"pass\"/> is returned. Otherwise, an error description is returned as follows: <info result=\"fail\"><error code=\"errcode\" line=\"line\" column=\"column\">error description</error></info>.", new SequenceType[]{new FunctionParameterSequenceType("expression", 22, 2, "The XPath/XQuery expression."), new FunctionParameterSequenceType("module-load-path", 22, 3, "The module load path. Imports will be resolved relative to this. Use xmldb:exist:///db if your modules are stored in db.")}, new FunctionReturnSequenceType(1, 2, "the results of the expression"))};
    private static final QName QNAME_INFO = new QName("info", "");
    private static final QName ERROR_INFO = new QName("error", "");
    private static final QName QNAME_RESULT_ATTR = new QName("result", "");
    private static final QName QNAME_ERRCODE_ATTR = new QName("code", "");
    private static final QName QNAME_LINE_ATTR = new QName("line", "");
    private static final QName QNAME_COLUMN_ATTR = new QName("column", "");

    public Compile(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String expr = args[0].getStringValue();
        if ("".equals(expr.trim())) {
            return new EmptySequence();
        }
        this.context.pushNamespaceContext();
        logger.debug("eval: " + expr);
        String error = null;
        ErrorCodes.ErrorCode code = null;
        int line = -1;
        int column = -1;
        XQueryContext pContext = new XQueryContext(this.context.getBroker().getBrokerPool());
        if (this.getArgumentCount() == 2 && args[1].hasOne()) {
            pContext.setModuleLoadPath(args[1].getStringValue());
        }
        XQueryLexer lexer = new XQueryLexer(pContext, new StringReader(expr));
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser astParser = new XQueryTreeParser(pContext);
        try {
            parser.xpath();
            if (parser.foundErrors()) {
                logger.debug(parser.getErrorMessage());
                throw new XPathException((Expression)this, "error found while executing expression: " + parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            PathExpr path = new PathExpr(pContext);
            astParser.xpath(ast, path);
            if (astParser.foundErrors()) {
                throw astParser.getLastException();
            }
            path.analyze(new AnalyzeContextInfo());
        }
        catch (RecognitionException e) {
            error = e.toString();
        }
        catch (TokenStreamException e) {
            error = e.toString();
        }
        catch (XPathException e) {
            line = e.getLine();
            column = e.getColumn();
            code = e.getCode();
            error = e.getDetailMessage();
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        finally {
            this.context.popNamespaceContext();
            pContext.reset(false);
        }
        if (this.isCalledAs("compile")) {
            return error == null ? Sequence.EMPTY_SEQUENCE : new StringValue(error);
        }
        return this.response(pContext, error, code, line, column);
    }

    private Sequence response(XQueryContext pContext, String error, ErrorCodes.ErrorCode code, int line, int column) {
        this.context.pushDocumentContext();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        builder.startElement(QNAME_INFO, null);
        builder.addAttribute(QNAME_RESULT_ATTR, error == null ? "pass" : "fail");
        if (error != null) {
            builder.startElement(ERROR_INFO, null);
            if (code != null) {
                builder.addAttribute(QNAME_ERRCODE_ATTR, code.toString());
            }
            if (line > -1) {
                builder.addAttribute(QNAME_LINE_ATTR, Integer.toString(line));
                builder.addAttribute(QNAME_COLUMN_ATTR, Integer.toString(column));
            }
            builder.characters(error);
            builder.endElement();
        }
        builder.endElement();
        return builder.getDocument().getNode(1);
    }
}

