/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class DeepCopyFunction
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(DeepCopyFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("deep-copy", "http://exist-db.org/xquery/util", "util"), "Creates a new, entirely in-memory copy of the passed in item.", new SequenceType[]{new FunctionParameterSequenceType("item", 11, 3, "The item to be copied")}, new FunctionReturnSequenceType(11, 3, "The copied item"));

    public DeepCopyFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Item a = args[0].itemAt(0);
        MemTreeBuilder builder = new MemTreeBuilder(this.context);
        builder.startDocument();
        DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
        try {
            Properties props = new Properties();
            a.toSAX(this.context.getBroker(), receiver, props);
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, "Cannot Deep-copy Item");
        }
        builder.endDocument();
        return (NodeValue)((Object)receiver.getDocument().getDocumentElement());
    }
}

