/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.Annotation;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.Module;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.inspect.InspectFunction;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.helpers.AttributesImpl;

public class DescribeFunction
extends Function {
    protected static final Logger logger = LogManager.getLogger(DescribeFunction.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("describe-function", "http://exist-db.org/xquery/util", "util"), "Describes a built-in function. Returns an element describing the function signature.", new SequenceType[]{new FunctionParameterSequenceType("function-name", 24, 2, "The name of the function to get the signature of")}, (SequenceType)new FunctionReturnSequenceType(-1, 2, "the signature of the function"), InspectFunction.SIGNATURE);
    private static final QName ANNOTATION_QNAME = new QName("annotation", "");
    private static final QName ANNOTATION_VALUE_QNAME = new QName("value", "");

    public DescribeFunction(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        QName qname;
        String fname = this.getArgument(0).eval(contextSequence, contextItem).getStringValue();
        try {
            qname = QName.parse(this.context, fname, this.context.getDefaultFunctionNamespace());
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0081, "No namespace defined for prefix " + fname);
        }
        String uri = qname.getNamespaceURI();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "name", "name", "CDATA", qname.getStringValue());
        attribs.addAttribute("", "module", "module", "CDATA", uri);
        int nodeNr = builder.startElement("", "function", "function", attribs);
        Module module = this.context.getModule(uri);
        if (module != null) {
            Iterator<FunctionSignature> i = module.getSignaturesForFunction(qname);
            while (i.hasNext()) {
                FunctionSignature signature = i.next();
                this.writeSignature(signature, builder);
            }
        } else {
            Iterator<FunctionSignature> i = this.context.getSignaturesForFunction(qname);
            while (i.hasNext()) {
                FunctionSignature signature = i.next();
                this.writeSignature(signature, builder);
            }
        }
        builder.endElement();
        return builder.getDocument().getNode(nodeNr);
    }

    private void writeSignature(FunctionSignature signature, MemTreeBuilder builder) throws XPathException {
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "arguments", "arguments", "CDATA", Integer.toString(signature.getArgumentCount()));
        builder.startElement("", "prototype", "prototype", attribs);
        attribs.clear();
        builder.startElement("", "signature", "signature", attribs);
        builder.characters(signature.toString());
        builder.endElement();
        this.writeAnnotations(signature, builder);
        if (signature.getDescription() != null) {
            SequenceType returnType;
            builder.startElement("", "description", "description", attribs);
            StringBuilder description = new StringBuilder();
            description.append(signature.getDescription());
            description.append("\n\n");
            SequenceType[] argumentTypes = signature.getArgumentTypes();
            if (argumentTypes != null && argumentTypes.length > 0) {
                StringBuilder args = new StringBuilder();
                int noArgs = 0;
                for (SequenceType argumentType : argumentTypes) {
                    if (!(argumentType instanceof FunctionParameterSequenceType)) continue;
                    ++noArgs;
                    FunctionParameterSequenceType fp = (FunctionParameterSequenceType)argumentType;
                    args.append("$");
                    args.append(fp.getAttributeName());
                    args.append(" : ");
                    args.append(fp.getDescription());
                    args.append("\n");
                }
                if (noArgs > 0) {
                    description.append("Parameters:\n");
                    description.append((CharSequence)args);
                }
            }
            if ((returnType = signature.getReturnType()) != null && returnType instanceof FunctionReturnSequenceType) {
                description.append("\n");
                description.append("Returns ");
                FunctionReturnSequenceType fp = (FunctionReturnSequenceType)returnType;
                description.append(fp.getDescription());
                description.append("\n");
            }
            builder.characters(description.toString());
            builder.endElement();
        }
        if (signature.getDeprecated() != null) {
            builder.startElement("", "deprecated", "deprecated", attribs);
            builder.characters(signature.getDeprecated());
            builder.endElement();
        }
        builder.endElement();
    }

    private void writeAnnotations(FunctionSignature signature, MemTreeBuilder builder) throws XPathException {
        AttributesImpl attribs = new AttributesImpl();
        Annotation[] annots = signature.getAnnotations();
        if (annots != null) {
            for (Annotation annot : annots) {
                attribs.clear();
                attribs.addAttribute(null, "name", "name", "CDATA", annot.getName().toString());
                attribs.addAttribute(null, "namespace", "namespace", "CDATA", annot.getName().getNamespaceURI());
                builder.startElement(ANNOTATION_QNAME, attribs);
                LiteralValue[] value = annot.getValue();
                if (value != null) {
                    for (LiteralValue literal : value) {
                        builder.startElement(ANNOTATION_VALUE_QNAME, null);
                        builder.characters(literal.getValue().getStringValue());
                        builder.endElement();
                    }
                }
                builder.endElement();
            }
        }
    }
}

