/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.InMemoryNodeSet;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;

public class Expand
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Expand.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("expand", "http://exist-db.org/xquery/util", "util"), "Creates an in-memory copy of the passed node set, using the specified serialization options. By default, full-text match terms will be tagged with &lt;exist:match&gt; and XIncludes will be expanded.", new SequenceType[]{new FunctionParameterSequenceType("node", -1, 7, "The node(s) to create in-memory copies of.")}, new FunctionReturnSequenceType(-1, 7, "the results")), new FunctionSignature(new QName("expand", "http://exist-db.org/xquery/util", "util"), "Creates an in-memory copy of the passed node set, using the specified serialization options. By default, full-text match terms will be tagged with &lt;exist:match&gt; and XIncludes will be expanded. Serialization parameters can be set in the second argument, which accepts the same parameters as the exist:serialize option.", new SequenceType[]{new FunctionParameterSequenceType("node", -1, 7, "The node(s) to create in-memory copies of."), new FunctionParameterSequenceType("serialization-parameters", 22, 2, "The serialization parameters")}, new FunctionReturnSequenceType(-1, 7, "the results"))};

    public Expand(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Properties serializeOptions = new Properties();
        serializeOptions.setProperty("expand-xincludes", "yes");
        serializeOptions.setProperty("highlight-matches", "elements");
        if (this.getArgumentCount() == 2) {
            String serOpts = args[1].getStringValue();
            String[] contents = Option.tokenize(serOpts);
            for (int i = 0; i < contents.length; ++i) {
                String[] pair = Option.parseKeyValuePair(contents[i]);
                if (pair == null) {
                    throw new XPathException((Expression)this, "Found invalid serialization option: " + contents[i]);
                }
                logger.debug("Setting serialization property: " + pair[0] + " = " + pair[1]);
                serializeOptions.setProperty(pair[0], pair[1]);
            }
        } else {
            this.context.checkOptions(serializeOptions);
        }
        this.context.pushDocumentContext();
        try {
            InMemoryNodeSet result = new InMemoryNodeSet();
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder, true);
            SequenceIterator i = args[0].iterate();
            while (i.hasNext()) {
                int nodeNr = builder.getDocument().getLastNode();
                NodeValue next = (NodeValue)i.nextItem();
                next.toSAX(this.context.getBroker(), receiver, serializeOptions);
                result.add(builder.getDocument().getNode(nodeNr + 1));
            }
            InMemoryNodeSet inMemoryNodeSet = result;
            return inMemoryNodeSet;
        }
        catch (SAXException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
        finally {
            this.context.popDocumentContext();
        }
    }
}

