/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunctionFunction
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(FunctionFunction.class);
    protected static final FunctionParameterSequenceType functionName = new FunctionParameterSequenceType("name", 24, 2, "The name of the function");
    protected static final FunctionParameterSequenceType arity = new FunctionParameterSequenceType("arity", 31, 2, "The arity of the function");
    protected static final FunctionReturnSequenceType result = new FunctionReturnSequenceType(101, 2, "the reference to the XQuery function");
    public static final FunctionSignature signature = new FunctionSignature(new QName("function", "http://exist-db.org/xquery/util", "util"), "Creates a reference to an XQuery function which can later be called from util:call. This allows for higher-order functions to be implemented in XQuery. A higher-order function is a function that takes another function as argument. The first argument represents the name of the function, which should bea valid QName. The second argument is the arity (number of parameters) of the function. If no function can be found that matches the name and arity, an error is thrown. Please note: the arguments to this function have to be literals or need to be resolvable at compile time at least.", new SequenceType[]{functionName, arity}, result);
    private FunctionCall resolvedFunction = null;

    public FunctionFunction(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        String funcName = this.getArgument(0).eval(null).getStringValue();
        int arity = ((NumericValue)this.getArgument(1).eval(null).itemAt(0)).getInt();
        FunctionCall funcCall = this.lookupFunction(funcName, arity);
        contextInfo.addFlag(1);
        funcCall.analyze(contextInfo);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String funcName = args[0].getStringValue();
        int arity = ((NumericValue)args[1].itemAt(0)).getInt();
        this.resolvedFunction = this.lookupFunction(funcName, arity);
        return new FunctionReference(this.resolvedFunction);
    }

    private FunctionCall lookupFunction(String funcName, int arity) throws XPathException {
        UserDefinedFunction func;
        QName qname;
        try {
            qname = QName.parse(this.context, funcName, this.context.getDefaultFunctionNamespace());
        }
        catch (QName.IllegalQNameException e) {
            throw new XPathException((Expression)this, ErrorCodes.XPST0081, "No namespace defined for prefix " + funcName);
        }
        Module module = this.context.getModule(qname.getNamespaceURI());
        if (module == null) {
            func = this.context.resolveFunction(qname, arity);
        } else {
            if (module.isInternalModule()) {
                logger.error("Cannot create a reference to an internal Java function");
                throw new XPathException((Expression)this, "Cannot create a reference to an internal Java function");
            }
            func = ((ExternalModule)module).getFunction(qname, arity, this.context);
        }
        if (func == null) {
            throw new XPathException((Expression)this, Messages.getMessage("S03", qname, Integer.toString(arity)));
        }
        FunctionCall funcCall = new FunctionCall(this.context, func);
        funcCall.setLocation(this.line, this.column);
        return funcCall;
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (this.resolvedFunction != null) {
            this.resolvedFunction.resetState(postOptimization);
        }
        if (!postOptimization) {
            this.resolvedFunction = null;
        }
    }
}

