/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.NodeId;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class GetNodeById
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(GetNodeById.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("node-by-id", "http://exist-db.org/xquery/util", "util"), "Retrieves a node by its internal node-id. The document is specified via the first argument. It may either be a document node or another node from the same document from which the target node will be retrieved by its id. The second argument is the internal node-id, specified as a string. Please note: the function does not check if the passed id does really point to an existing node. It just returns a pointer, which may thus be invalid.", new SequenceType[]{new FunctionParameterSequenceType("document", -1, 2, "The document whose node is to be retrieved by its id"), new FunctionParameterSequenceType("node-id", 22, 2, "The internal node id")}, new FunctionReturnSequenceType(-1, 2, "the node"));

    public GetNodeById(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String id = args[1].itemAt(0).getStringValue();
        NodeId nodeId = this.context.getBroker().getBrokerPool().getNodeFactory().createFromString(id);
        NodeValue docNode = (NodeValue)args[0].itemAt(0);
        if (docNode.getImplementationType() == 0) {
            return ((NodeImpl)docNode).getOwnerDocument().getNodeById(nodeId);
        }
        DocumentImpl doc = ((NodeProxy)docNode).getOwnerDocument();
        return new NodeProxy(doc, nodeId);
    }
}

