/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.OrderedValuesIndex;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.storage.Indexable;
import org.exist.util.Occurrences;
import org.exist.util.ValueOccurrences;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class IndexKeys
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(IndexKeys.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("index-keys", "http://exist-db.org/xquery/util", "util"), "Can be used to query existing range indexes defined on a set of nodes. All index keys defined for the given node set are reported to a callback function. The function will check for indexes defined on path as well as indexes defined by QName. ", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "The node set"), new FunctionParameterSequenceType("start-value", 20, 3, "Only index keys of the same type but being greater than $start-value will be reported for non-string types. For string types, only keys starting with the given prefix are reported."), new FunctionParameterSequenceType("function-reference", 101, 2, "The function reference as created by the util:function function. It can be an arbitrary user-defined function, but it should take exactly 2 arguments: 1) the current index key as found in the range index as an atomic value, 2) a sequence containing three int values: a) the overall frequency of the key within the node set, b) the number of distinct documents in the node set the key occurs in, c) the current position of the key in the whole list of keys returned."), new FunctionParameterSequenceType("max-number-returned", 38, 3, "The maximum number of returned keys")}, new FunctionReturnSequenceType(11, 7, "the results of the eval of the $function-reference")), new FunctionSignature(new QName("index-keys", "http://exist-db.org/xquery/util", "util"), "Can be used to query existing range indexes defined on a set of nodes. All index keys defined for the given node set are reported to a callback function. The function will check for indexes defined on path as well as indexes defined by QName. ", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "The node set"), new FunctionParameterSequenceType("start-value", 20, 3, "Only index keys of the same type but being greater than $start-value will be reported for non-string types. For string types, only keys starting with the given prefix are reported."), new FunctionParameterSequenceType("function-reference", 101, 2, "The function reference as created by the util:function function. It can be an arbitrary user-defined function, but it should take exactly 2 arguments: 1) the current index key as found in the range index as an atomic value, 2) a sequence containing three int values: a) the overall frequency of the key within the node set, b) the number of distinct documents in the node set the key occurs in, c) the current position of the key in the whole list of keys returned."), new FunctionParameterSequenceType("max-number-returned", 38, 3, "The maximum number of returned keys"), new FunctionParameterSequenceType("index", 22, 2, "The index in which the search is made")}, new FunctionReturnSequenceType(11, 7, "the results of the eval of the $function-reference")), new FunctionSignature(new QName("index-keys-by-qname", "http://exist-db.org/xquery/util", "util"), "Can be used to query existing range indexes defined on a set of nodes. All index keys defined for the given node set are reported to a callback function. The function will check for indexes defined on path as well as indexes defined by QName. ", new SequenceType[]{new FunctionParameterSequenceType("qname", 24, 7, "The node set"), new FunctionParameterSequenceType("start-value", 20, 3, "Only index keys of the same type but being greater than $start-value will be reported for non-string types. For string types, only keys starting with the given prefix are reported."), new FunctionParameterSequenceType("function-reference", 101, 2, "The function reference as created by the util:function function. It can be an arbitrary user-defined function, but it should take exactly 2 arguments: 1) the current index key as found in the range index as an atomic value, 2) a sequence containing three int values: a) the overall frequency of the key within the node set, b) the number of distinct documents in the node set the key occurs in, c) the current position of the key in the whole list of keys returned."), new FunctionParameterSequenceType("max-number-returned", 38, 3, "The maximum number of returned keys"), new FunctionParameterSequenceType("index", 22, 2, "The index in which the search is made")}, new FunctionReturnSequenceType(11, 7, "the results of the eval of the $function-reference"))};

    public IndexKeys(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeSet nodes = null;
        DocumentSet docs = null;
        Sequence qnames = null;
        if (this.isCalledAs("index-keys-by-qname")) {
            qnames = args[0];
            docs = contextSequence == null ? this.context.getStaticallyKnownDocuments() : contextSequence.getDocumentSet();
        } else {
            nodes = args[0].toNodeSet();
            docs = nodes.getDocumentSet();
        }
        FunctionReference ref = (FunctionReference)args[2].itemAt(0);
        int max = -1;
        if (args[3].hasOne()) {
            max = ((IntegerValue)args[3].itemAt(0)).getInt();
        }
        ValueSequence result = new ValueSequence();
        if (this.getArgumentCount() == 5) {
            IndexWorker indexWorker = this.context.getBroker().getIndexController().getWorkerByIndexName(args[4].itemAt(0).getStringValue());
            if (indexWorker == null) {
                throw new XPathException((Expression)this, "Unknown index: " + args[4].itemAt(0).getStringValue());
            }
            HashMap<String, Object> hints = new HashMap<String, Object>();
            if (max != -1) {
                hints.put("value_count", new IntegerValue(max));
            }
            if (indexWorker instanceof OrderedValuesIndex) {
                hints.put("start_value", args[1].getStringValue());
            } else {
                logger.warn(indexWorker.getClass().getName() + " isn't an instance of org.exist.indexing.OrderedIndexWorker. Start value '" + args[1] + "' ignored.");
            }
            if (qnames != null) {
                ArrayList<QName> qnameList = new ArrayList<QName>(qnames.getItemCount());
                SequenceIterator i = qnames.iterate();
                while (i.hasNext()) {
                    QNameValue qv = (QNameValue)i.nextItem();
                    qnameList.add(qv.getQName());
                }
                hints.put("qnames_key", qnameList);
            }
            Occurrences[] occur = indexWorker.scanIndex(this.context, docs, nodes, hints);
            int len = max != -1 && occur.length > max ? max : occur.length;
            Sequence[] params = new Sequence[2];
            ValueSequence data = new ValueSequence();
            for (int j = 0; j < len; ++j) {
                params[0] = new StringValue(occur[j].getTerm().toString());
                data.add(new IntegerValue(occur[j].getOccurrences(), 43));
                data.add(new IntegerValue(occur[j].getDocuments(), 43));
                data.add(new IntegerValue(j + 1, 43));
                params[1] = data;
                result.addAll(ref.evalFunction(Sequence.EMPTY_SEQUENCE, null, params));
                data.clear();
            }
        } else {
            Indexable indexable = (Indexable)((Object)args[1].itemAt(0));
            ValueOccurrences[] occur = null;
            QName[] allQNames = this.getDefinedIndexes(this.context.getBroker(), docs);
            if (allQNames.length > 0) {
                occur = this.context.getBroker().getValueIndex().scanIndexKeys(docs, nodes, allQNames, indexable);
            }
            ValueOccurrences[] occur2 = this.context.getBroker().getValueIndex().scanIndexKeys(docs, nodes, indexable);
            if (occur == null || occur.length == 0) {
                occur = occur2;
            } else {
                ValueOccurrences[] t = new ValueOccurrences[occur.length + occur2.length];
                System.arraycopy(occur, 0, t, 0, occur.length);
                System.arraycopy(occur2, 0, t, occur.length, occur2.length);
                occur = t;
            }
            int len = max != -1 && occur.length > max ? max : occur.length;
            Sequence[] params = new Sequence[2];
            ValueSequence data = new ValueSequence();
            for (int j = 0; j < len; ++j) {
                params[0] = occur[j].getValue();
                data.add(new IntegerValue(occur[j].getOccurrences(), 43));
                data.add(new IntegerValue(occur[j].getDocuments(), 43));
                data.add(new IntegerValue(j + 1, 43));
                params[1] = data;
                result.addAll(ref.evalFunction(Sequence.EMPTY_SEQUENCE, null, params));
                data.clear();
            }
        }
        logger.debug("Returning: " + result.getItemCount());
        return result;
    }

    @Override
    public int getDependencies() {
        if (this.isCalledAs("index-keys-by-qname")) {
            return 1;
        }
        return this.getArgument(0).getDependencies();
    }

    private QName[] getDefinedIndexes(DBBroker broker, DocumentSet docs) {
        HashSet<QName> indexes = new HashSet<QName>();
        Iterator<Collection> i = docs.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = i.next();
            IndexSpec idxConf = collection.getIndexConfiguration(broker);
            if (idxConf == null) continue;
            List<QName> qnames = idxConf.getIndexedQNames();
            for (int j = 0; j < qnames.size(); ++j) {
                QName qName = qnames.get(j);
                indexes.add(qName);
            }
        }
        QName[] qnames = new QName[indexes.size()];
        return indexes.toArray(qnames);
    }
}

