/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentSet;
import org.exist.util.LockException;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public abstract class LockFunction
extends Function {
    protected static final Logger logger = LogManager.getLogger(LockFunction.class);
    protected final boolean exclusive;

    protected LockFunction(XQueryContext context, FunctionSignature signature, boolean exclusive) {
        super(context, signature);
        this.exclusive = exclusive;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence docsArg = this.getArgument(0).eval(contextSequence, contextItem);
        DocumentSet docs = docsArg.getDocumentSet();
        try {
            docs.lock(this.context.getBroker(), this.exclusive);
            Sequence sequence = this.getArgument(1).eval(contextSequence, contextItem);
            return sequence;
        }
        catch (LockException e) {
            throw new XPathException((Expression)this, "Could not lock document set", (Throwable)e);
        }
        finally {
            docs.unlock();
        }
    }

    @Override
    public int getCardinality() {
        return this.getArgument(1).getCardinality();
    }

    @Override
    public int returnsType() {
        return this.getArgument(1).returnsType();
    }
}

