/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.source.Source;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.inspect.InspectModule;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class ModuleInfo
extends BasicFunction {
    protected static final FunctionParameterSequenceType NAMESPACE_URI_PARAMETER = new FunctionParameterSequenceType("namespace-uri", 22, 2, "The namespace URI of the module");
    protected static final FunctionParameterSequenceType LOCATION_URI_PARAMETER = new FunctionParameterSequenceType("location-uri", 22, 2, "The location URI of the module");
    protected static final Logger logger = LogManager.getLogger(ModuleInfo.class);
    public static final FunctionSignature registeredModulesSig = new FunctionSignature(new QName("registered-modules", "http://exist-db.org/xquery/util", "util"), "Returns a sequence containing the namespace URIs of all modules currently known to the system, including built in and imported modules.", null, new FunctionReturnSequenceType(22, 6, "the sequence of all of the active function modules namespace URIs"));
    public static final FunctionSignature registeredModuleSig = new FunctionSignature(new QName("is-module-registered", "http://exist-db.org/xquery/util", "util"), "Returns a Boolean value if the module identified by the namespace URI is registered.", new SequenceType[]{NAMESPACE_URI_PARAMETER}, new FunctionReturnSequenceType(23, 2, "true if the namespace URI is registered as an active function module"));
    public static final FunctionSignature mappedModulesSig = new FunctionSignature(new QName("mapped-modules", "http://exist-db.org/xquery/util", "util"), "Returns a sequence containing the namespace URIs of all XQuery modules which are statically mapped to a source location in the configuration file. This does not include any built in modules.", null, new FunctionReturnSequenceType(22, 6, "the sequence of all of the active function modules namespace URIs"));
    public static final FunctionSignature mappedModuleSig = new FunctionSignature(new QName("is-module-mapped", "http://exist-db.org/xquery/util", "util"), "Returns a Boolean value if the module statically mapped to a source location in the configuration file.", new SequenceType[]{NAMESPACE_URI_PARAMETER}, new FunctionReturnSequenceType(23, 2, "true if the namespace URI is mapped as an active function module"));
    public static final FunctionSignature mapModuleSig = new FunctionSignature(new QName("map-module", "http://exist-db.org/xquery/util", "util"), "Map the module to a source location. This function is only available to the DBA role.", new SequenceType[]{NAMESPACE_URI_PARAMETER, LOCATION_URI_PARAMETER}, new FunctionReturnSequenceType(11, 1, "Returns an empty sequence"));
    public static final FunctionSignature unmapModuleSig = new FunctionSignature(new QName("unmap-module", "http://exist-db.org/xquery/util", "util"), "Remove relation between module namespace and source location. This function is only available to the DBA role.", new SequenceType[]{NAMESPACE_URI_PARAMETER}, new FunctionReturnSequenceType(11, 1, "Returns an empty sequence"));
    public static final FunctionSignature moduleDescriptionSig = new FunctionSignature(new QName("get-module-description", "http://exist-db.org/xquery/util", "util"), "Returns a short description of the module identified by the namespace URI.", new SequenceType[]{NAMESPACE_URI_PARAMETER}, (SequenceType)new FunctionReturnSequenceType(22, 2, "the description of the active function module identified by the namespace URI"), InspectModule.FNS_INSPECT_MODULE_URI);
    public static final FunctionSignature moduleInfoSig = new FunctionSignature(new QName("get-module-info", "http://exist-db.org/xquery/util", "util"), "Returns an XML fragment providing additional information about the module identified by the namespace URI.", null, new FunctionReturnSequenceType(1, 2, "the description of the active function module identified by the namespace URI"));
    public static final FunctionSignature moduleInfoWithURISig = new FunctionSignature(new QName("get-module-info", "http://exist-db.org/xquery/util", "util"), "Returns an XML fragment providing additional information about the module identified by the namespace URI.", new SequenceType[]{NAMESPACE_URI_PARAMETER}, (SequenceType)new FunctionReturnSequenceType(1, 2, "the description of the active function module identified by the namespace URI"), InspectModule.FNS_INSPECT_MODULE_URI);
    private static final QName MODULE_QNAME = new QName("module", "");
    private static final QName MODULE_URI_ATTR = new QName("uri", "");
    private static final QName MODULE_PREFIX_ATTR = new QName("prefix", "");
    private static final QName MODULE_SOURCE_ATTR = new QName("source", "");
    private static final QName MODULE_DESC_QNAME = new QName("description", "");
    private static final QName MODULES_QNAME = new QName("modules", "");

    public ModuleInfo(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if ("get-module-description".equals(this.getSignature().getName().getLocalPart())) {
            String uri = args[0].getStringValue();
            Module module = this.context.getModule(uri);
            if (module == null) {
                throw new XPathException((Expression)this, "No module found matching namespace URI: " + uri);
            }
            return new StringValue(module.getDescription());
        }
        if ("is-module-registered".equals(this.getSignature().getName().getLocalPart())) {
            String uri = args[0].getStringValue();
            Module module = this.context.getModule(uri);
            return new BooleanValue(module != null);
        }
        if ("mapped-modules".equals(this.getSignature().getName().getLocalPart())) {
            ValueSequence resultSeq = new ValueSequence();
            Iterator<String> i = this.context.getMappedModuleURIs();
            while (i.hasNext()) {
                resultSeq.add(new StringValue(i.next()));
            }
            return resultSeq;
        }
        if ("is-module-mapped".equals(this.getSignature().getName().getLocalPart())) {
            String uri = args[0].getStringValue();
            return new BooleanValue(((Map)this.context.getBroker().getConfiguration().getProperty("xquery.modules.static")).get(uri) != null);
        }
        if ("map-module".equals(this.getSignature().getName().getLocalPart())) {
            if (!this.context.getSubject().hasDbaRole()) {
                XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
                logger.error("Invalid user", (Throwable)xPathException);
                throw xPathException;
            }
            String namespace = args[0].getStringValue();
            String location = args[1].getStringValue();
            Map moduleMap = (Map)this.context.getBroker().getConfiguration().getProperty("xquery.modules.static");
            moduleMap.put(namespace, location);
            return Sequence.EMPTY_SEQUENCE;
        }
        if ("unmap-module".equals(this.getSignature().getName().getLocalPart())) {
            if (!this.context.getSubject().hasDbaRole()) {
                XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
                logger.error("Invalid user", (Throwable)xPathException);
                throw xPathException;
            }
            String namespace = args[0].getStringValue();
            Map moduleMap = (Map)this.context.getBroker().getConfiguration().getProperty("xquery.modules.static");
            moduleMap.remove(namespace);
            return Sequence.EMPTY_SEQUENCE;
        }
        if ("get-module-info".equals(this.getSignature().getName().getLocalPart())) {
            this.context.pushDocumentContext();
            try {
                Object i;
                MemTreeBuilder builder = this.context.getDocumentBuilder();
                builder.startElement(MODULES_QNAME, null);
                if (this.getArgumentCount() == 1) {
                    Module module = this.context.getModule(args[0].getStringValue());
                    if (module != null) {
                        this.outputModule(builder, module);
                    }
                } else {
                    i = this.context.getRootModules();
                    while (i.hasNext()) {
                        Module module = i.next();
                        this.outputModule(builder, module);
                    }
                }
                i = builder.getDocument().getNode(1);
                return i;
            }
            finally {
                this.context.popDocumentContext();
            }
        }
        ValueSequence resultSeq = new ValueSequence();
        XQueryContext tempContext = new XQueryContext(this.context.getBroker().getBrokerPool());
        Iterator<Module> i = tempContext.getRootModules();
        while (i.hasNext()) {
            Module module = i.next();
            resultSeq.add(new StringValue(module.getNamespaceURI()));
        }
        if (tempContext.getRepository().isPresent()) {
            for (URI uri : tempContext.getRepository().get().getJavaModules()) {
                resultSeq.add(new StringValue(uri.toString()));
            }
        }
        return resultSeq;
    }

    private void outputModule(MemTreeBuilder builder, Module module) {
        Source source;
        builder.startElement(MODULE_QNAME, null);
        builder.addAttribute(MODULE_URI_ATTR, module.getNamespaceURI());
        builder.addAttribute(MODULE_PREFIX_ATTR, module.getDefaultPrefix());
        if (!module.isInternalModule() && (source = ((ExternalModule)module).getSource()) != null) {
            builder.addAttribute(MODULE_SOURCE_ATTR, source.getKey().toString());
        }
        builder.startElement(MODULE_DESC_QNAME, null);
        builder.characters(module.getDescription());
        builder.endElement();
        builder.endElement();
    }
}

