/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class NodeId
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(NodeId.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("node-id", "http://exist-db.org/xquery/util", "util"), "Returns the internal node-id of a node. The internal node-id uniquely identifies a node within its document. It is encoded as a long number.", new SequenceType[]{new FunctionParameterSequenceType("node", -1, 2, "The node to get the internal node-id from")}, new FunctionReturnSequenceType(22, 2, "the internal node-id"));

    public NodeId(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeValue docNode = (NodeValue)args[0].itemAt(0);
        org.exist.numbering.NodeId nodeId = docNode.getImplementationType() == 0 ? ((NodeImpl)docNode).getNodeId() : ((NodeProxy)docNode).getNodeId();
        return new StringValue(nodeId.toString());
    }
}

