/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Profile
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Profile.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("enable-profiling", "http://exist-db.org/xquery/util", "util"), "Enable profiling output within the query. The profiling starts with this function call and will end with a call to 'disable-profiling'. Argument $verbosity specifies the verbosity. All other profiling options can be configured via the 'declare option exist:profiling ...' in the query prolog.", new SequenceType[]{new FunctionParameterSequenceType("verbosity", 38, 2, "The verbosity of the profiling")}, new SequenceType(11, 1)), new FunctionSignature(new QName("disable-profiling", "http://exist-db.org/xquery/util", "util"), "Disable profiling output within the query.", null, new SequenceType(11, 1))};

    public Profile(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Profiler profiler = this.context.getProfiler();
        if (this.isCalledAs("enable-profiling")) {
            int verbosity = ((IntegerValue)args[0].itemAt(0)).getInt();
            profiler.setEnabled(true);
            profiler.setVerbosity(verbosity);
        } else {
            profiler.setEnabled(false);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

