/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.NodeSet;
import org.exist.storage.NativeValueIndex;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Constants;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.RootNode;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class QNameIndexLookup
extends Function {
    protected static final Logger logger = LogManager.getLogger(QNameIndexLookup.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("qname-index-lookup", "http://exist-db.org/xquery/util", "util"), "Can be used to query existing qname indexes defined on a set of nodes. ", new SequenceType[]{new FunctionParameterSequenceType("qname", 24, 2, "The QName"), new FunctionParameterSequenceType("comparison-value", 20, 2, "The comparison value")}, new FunctionReturnSequenceType(-1, 7, "the result"));

    public QNameIndexLookup(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public int getDependencies() {
        return 1;
    }

    @Override
    public void setArguments(List<Expression> arguments) throws XPathException {
        Expression arg = arguments.get(0);
        arg = new DynamicCardinalityCheck(this.context, 6, arg, new Error("D02", "1", this.mySignature));
        this.steps.add(arg);
        arg = arguments.get(1);
        arg = new DynamicCardinalityCheck(this.context, 6, arg, new Error("D02", "2", this.mySignature));
        this.steps.add(arg);
    }

    @Override
    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            this.getArgument(i).analyze(contextInfo);
        }
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        QNameValue qval;
        if (contextSequence == null || contextSequence.isEmpty()) {
            RootNode rootNode = new RootNode(this.context);
            contextSequence = rootNode.eval(null, null);
        }
        Sequence[] args = this.getArguments(null, null);
        Item item = args[0].itemAt(0);
        try {
            qval = (QNameValue)item.convertTo(24);
        }
        catch (XPathException e) {
            throw new XPathException((Expression)this, Messages.formatMessage("D06", new Object[]{"1", this.mySignature.toString(), null, Type.getTypeName(24), Type.getTypeName(item.getType())}));
        }
        QName qname = qval.getQName();
        AtomicValue comparisonCriterium = args[1].itemAt(0).atomize();
        NativeValueIndex valueIndex = this.context.getBroker().getValueIndex();
        NodeSet result = valueIndex.find(this.context.getWatchDog(), Constants.Comparison.EQ, contextSequence.getDocumentSet(), null, 0, qname, comparisonCriterium);
        return result;
    }
}

