/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.math.BigInteger;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class RandomFunction
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(RandomFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("random", "http://exist-db.org/xquery/util", "util"), "Returns a random number between 0.0 and 1.0", null, new FunctionReturnSequenceType(34, 2, "a random number between 0.0 and 1.0")), new FunctionSignature(new QName("random-ulong", "http://exist-db.org/xquery/util", "util"), "Returns a random number between 0 and the maximum xs:unsignedLong", null, new FunctionReturnSequenceType(42, 2, "a random number between 0 and the maximum xs:unsignedLong")), new FunctionSignature(new QName("random", "http://exist-db.org/xquery/util", "util"), "Returns a random number between 0 (inclusive) and $max (exclusive), that is, a number greater than or equal to 0 but less than $max", new SequenceType[]{new FunctionParameterSequenceType("max", 31, 2, "A number to be used as the exclusive maximum value for the random number; the return value will be less than this number.")}, new FunctionReturnSequenceType(31, 2, "a random number between 0 and $max"))};

    public RandomFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NumericValue result;
        Random rnd = new Random();
        if (this.getArgumentCount() == 0) {
            if (this.isCalledAs("random")) {
                result = new DoubleValue(rnd.nextDouble());
            } else {
                BigInteger rndInt = new BigInteger(64, rnd);
                result = new IntegerValue(rndInt, 42);
            }
        } else {
            IntegerValue upper = (IntegerValue)args[0].convertTo(31);
            result = new IntegerValue(rnd.nextInt(upper.getInt()));
        }
        return result;
    }
}

