/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.SerializerUtils;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class Serialize
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Serialize.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("serialize", "http://exist-db.org/xquery/util", "util"), "Writes the node set passed in parameter $a into a file on the file system. The full path to the file is specified in parameter $b. $c contains a sequence of zero or more serialization parameters specified as key=value pairs. The serialization options are the same as those recognized by \"declare option exist:serialize\". The function does NOT automatically inherit the serialization options of the XQuery it is called from. False is returned if the specified file can not be created or is not writable, true on success. The empty sequence is returned if the argument sequence is empty.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 2), new SequenceType(22, 7)}, new SequenceType(23, 3), "Use the file:serialize() function in the file extension module instead!"), new FunctionSignature(new QName("serialize", "http://exist-db.org/xquery/util", "util"), "Returns the Serialized node set passed in parameter $node-set. $parameters contains a sequence of zero or more serialization parameters specified as key=value pairs. The serialization options are the same as those recognized by \"declare option exist:serialize\". The function does NOT automatically inherit the serialization options of the XQuery it is called from.", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "The node set to serialize"), new FunctionParameterSequenceType("parameters", 11, 7, "The serialization parameters: either a sequence of key=value pairs or an output:serialization-parameters element as defined by the standard fn:serialize function.")}, (SequenceType)new FunctionParameterSequenceType("result", 22, 3, "the string containing the serialized node set."), "Use the fn:serialize() function instead!")};

    public Serialize(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Properties outputProperties = null;
        if (args.length == 3) {
            String path = args[1].itemAt(0).getStringValue();
            Path file = Paths.get(path, new String[0]).normalize();
            if (Files.isDirectory(file, new LinkOption[0])) {
                logger.debug("Output file is a directory: " + file.toAbsolutePath().toString());
                return BooleanValue.FALSE;
            }
            if (Files.exists(file, new LinkOption[0]) && !Files.isWritable(file)) {
                logger.debug("Cannot write to file " + file.toAbsolutePath().toString());
                return BooleanValue.FALSE;
            }
            outputProperties = this.parseSerializationOptions(args[2]);
            try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
                this.serialize(args[0].iterate(), outputProperties, os);
                return BooleanValue.TRUE;
            }
            catch (IOException e) {
                throw new XPathException((Expression)this, "A problem occurred while serializing the node set: " + e.getMessage(), (Throwable)e);
            }
        }
        outputProperties = this.parseSerializationOptions(args[1]);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.serialize(args[0].iterate(), outputProperties, (OutputStream)os);
            String encoding = outputProperties.getProperty("encoding", StandardCharsets.UTF_8.name());
            StringValue stringValue = new StringValue(new String(os.toByteArray(), encoding));
            return stringValue;
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "A problem occurred while serializing the node set: " + e.getMessage(), (Throwable)e);
        }
    }

    private Properties parseSerializationOptions(Sequence sSerializeParams) throws XPathException {
        Properties outputProperties = new Properties();
        if (sSerializeParams.hasOne() && Type.subTypeOf(sSerializeParams.getItemType(), -1)) {
            SerializerUtils.getSerializationOptions(this, (NodeValue)sSerializeParams.itemAt(0), outputProperties);
        } else {
            SequenceIterator siSerializeParams = sSerializeParams.iterate();
            outputProperties.setProperty("indent", "yes");
            outputProperties.setProperty("omit-xml-declaration", "yes");
            while (siSerializeParams.hasNext()) {
                String[] params;
                String serializeParams = siSerializeParams.nextItem().getStringValue();
                for (String param : params = serializeParams.split(" ")) {
                    String[] opt = Option.parseKeyValuePair(param);
                    outputProperties.setProperty(opt[0], opt[1]);
                }
            }
        }
        return outputProperties;
    }

    private void serialize(SequenceIterator siNode, Properties outputProperties, OutputStream os) throws XPathException {
        SAXSerializer sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        outputProperties.setProperty("sax-document-events", "false");
        String encoding = outputProperties.getProperty("encoding", "UTF-8");
        try (OutputStreamWriter writer = new OutputStreamWriter(os, encoding);){
            sax.setOutput(writer, outputProperties);
            Serializer serializer = this.context.getBroker().getSerializer();
            serializer.reset();
            serializer.setProperties(outputProperties);
            serializer.setSAXHandlers(sax, sax);
            sax.startDocument();
            while (siNode.hasNext()) {
                NodeValue next = (NodeValue)siNode.nextItem();
                serializer.toSAX(next);
            }
            sax.endDocument();
            ((Writer)writer).close();
        }
        catch (IOException | SAXException e) {
            throw new XPathException((Expression)this, "A problem occurred while serializing the node set: " + e.getMessage(), (Throwable)e);
        }
        finally {
            SerializerPool.getInstance().returnObject(sax);
        }
    }
}

