/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.SystemProperties;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class SystemProperty
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("system-property", "http://exist-db.org/xquery/util", "util"), "Returns the value of a system property. Similar to the corresponding XSLT function. Predefined properties are: vendor, vendor-url, product-name, product-version, product-build, and all Java system properties.", new SequenceType[]{new FunctionParameterSequenceType("property-name", 22, 2, "The name of the system property to retrieve the value of.")}, new FunctionReturnSequenceType(22, 3, "the value of the named system property"));

    public SystemProperty(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String key = args[0].getStringValue();
        String value = SystemProperties.getInstance().getSystemProperty(key, null);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value == null ? Sequence.EMPTY_SEQUENCE : new StringValue(value);
    }
}

