/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.Date;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class SystemTime
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("system-time", "http://exist-db.org/xquery/util", "util"), "Returns the current xs:time (with timezone) as reported by the Java method System.currentTimeMillis(). Contrary to fn:current-time, this function is not stable, i.e. the returned xs:time will change during the evaluation time of a query and can be used to measure time differences.", null, new FunctionReturnSequenceType(52, 2, "the current xs:time (with timezone)")), new FunctionSignature(new QName("system-date", "http://exist-db.org/xquery/util", "util"), "Returns the current xs:date (with timezone) as reported by the Java method System.currentTimeMillis(). Contrary to fn:current-date, this function is not stable, i.e. the returned xs:date will change during the evaluation time of a query and can be used to measure time differences.", null, new FunctionReturnSequenceType(51, 2, "the current xs:date (with timezone)")), new FunctionSignature(new QName("system-dateTime", "http://exist-db.org/xquery/util", "util"), "Returns the current xs:dateTime (with timezone) as reported by the Java method System.currentTimeMillis(). Contrary to fn:current-dateTime, this function is not stable, i.e. the returned xs:dateTime will change during the evaluation time of a query and can be used to measure time differences.", null, new FunctionReturnSequenceType(50, 2, "the current xs:dateTime (with timezone)"))};

    public SystemTime(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        AtomicValue result = new DateTimeValue(new Date());
        if (!this.isCalledAs("system-dateTime")) {
            if (this.isCalledAs("system-date")) {
                result = result.convertTo(51);
            } else if (this.isCalledAs("system-time")) {
                result = result.convertTo(52);
            } else {
                throw new Error("can't handle function " + this.mySignature.getName().getLocalPart());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    @Override
    public int getDependencies() {
        return 1;
    }
}

