/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.UUIDGenerator;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class UUID
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(UUID.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("uuid", "http://exist-db.org/xquery/util", "util"), "Generate a version 4 (random) universally unique identifier (UUID) string, e.g. 154ad200-9c79-44f3-8cff-9780d91552a6", FunctionSignature.NO_ARGS, new FunctionReturnSequenceType(22, 2, "a generated UUID string")), new FunctionSignature(new QName("uuid", "http://exist-db.org/xquery/util", "util"), "Generate a version 3 universally unique identifier (UUID) string, e.g. 2b92ddb6-8e4e-3891-b519-afa1609ced73", new SequenceType[]{new FunctionParameterSequenceType("name", 11, 2, "The input value for UUID calculation.")}, new FunctionReturnSequenceType(22, 2, "a generated UUID string"))};

    public UUID(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence result = new ValueSequence();
        if (args.length == 0) {
            String uuid = UUIDGenerator.getUUIDversion4();
            result.add(new StringValue(uuid));
        } else if (args.length == 1) {
            String parameter = args[0].getStringValue();
            String uuid = UUIDGenerator.getUUIDversion3(parameter);
            result.add(new StringValue(uuid));
        } else {
            logger.error("Not a supported number of parameters");
            throw new XPathException("Not a supported number of parameters");
        }
        return result;
    }
}

