/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FindLastModified
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("find-last-modified-since", "http://exist-db.org/xquery/xmldb", "xmldb"), "Filters the given node set to only include nodes from resources which were modified since the specified date time.", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "A node set"), new FunctionParameterSequenceType("since", 50, 2, "Date")}, new FunctionReturnSequenceType(-1, 7, "the filtered node set.")), new FunctionSignature(new QName("find-last-modified-until", "http://exist-db.org/xquery/xmldb", "xmldb"), "Filters the given node set to only include nodes from resources which were modified until the specified date time.", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "A node set"), new FunctionParameterSequenceType("until", 50, 2, "Date")}, new FunctionReturnSequenceType(-1, 7, "the filtered node set."))};

    public FindLastModified(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeSet nodes = args[0].toNodeSet();
        if (nodes.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NewArrayNodeSet result = new NewArrayNodeSet();
        DateTimeValue dtv = (DateTimeValue)args[1].itemAt(0);
        long lastModified = dtv.getDate().getTime();
        for (NodeProxy proxy : nodes) {
            boolean matches;
            DocumentImpl doc = proxy.getOwnerDocument();
            long modified = doc.getMetadata().getLastModified();
            if (this.isCalledAs("find-last-modified-since")) {
                matches = modified > lastModified;
            } else {
                boolean bl = matches = modified <= lastModified;
            }
            if (!matches) continue;
            result.add(proxy);
        }
        return result;
    }
}

