/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.persistent.NodeProxy;
import org.exist.xmldb.LocalCollection;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public abstract class XMLDBAbstractCollectionManipulator
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBAbstractCollectionManipulator.class);
    private final boolean errorIfAbsent;
    private int paramNumber = 0;

    protected void setCollectionParameterNumber(int paramNumber) {
        this.paramNumber = paramNumber;
    }

    protected int getCollectionParameterNumber() {
        return this.paramNumber;
    }

    public XMLDBAbstractCollectionManipulator(XQueryContext context, FunctionSignature signature) {
        this(context, signature, true);
    }

    public XMLDBAbstractCollectionManipulator(XQueryContext context, FunctionSignature signature, boolean errorIfAbsent) {
        super(context, signature);
        this.errorIfAbsent = errorIfAbsent;
    }

    protected LocalCollection createLocalCollection(String name) throws XMLDBException {
        try {
            return new LocalCollection(this.context.getSubject(), this.context.getBroker().getBrokerPool(), new AnyURIValue(name).toXmldbURI());
        }
        catch (XPathException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (0 == args.length) {
            throw new XPathException((Expression)this, "Expected a collection as the argument " + (this.paramNumber + 1) + ".");
        }
        boolean collectionNeedsClose = false;
        LocalCollection collection = null;
        Item item = args[this.paramNumber].itemAt(0);
        if (Type.subTypeOf(item.getType(), -1)) {
            NodeValue node = (NodeValue)item;
            logger.debug("Found node");
            if (node.getImplementationType() == 1) {
                Collection internalCol = ((NodeProxy)node).getOwnerDocument().getCollection();
                logger.debug("Found node");
                try {
                    collection = this.createLocalCollection(internalCol.getURI().toString());
                    logger.debug("Loaded collection " + collection.getName());
                }
                catch (XMLDBException e) {
                    throw new XPathException((Expression)this, "Failed to access collection: " + internalCol.getURI(), (Throwable)e);
                }
            } else {
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        if (collection == null) {
            String collectionURI = args[this.paramNumber].getStringValue();
            if (collectionURI != null) {
                try {
                    collection = !collectionURI.startsWith("xmldb:") ? this.createLocalCollection(collectionURI) : (collectionURI.startsWith("xmldb:exist:///") ? this.createLocalCollection(collectionURI.replaceFirst("xmldb:exist://", "")) : (collectionURI.startsWith("xmldb:exist://embedded-eXist-server") ? this.createLocalCollection(collectionURI.replaceFirst("xmldb:exist://embedded-eXist-server", "")) : (collectionURI.startsWith("xmldb:exist://localhost") ? this.createLocalCollection(collectionURI.replaceFirst("xmldb:exist://localhost", "")) : (collectionURI.startsWith("xmldb:exist://127.0.0.1") ? this.createLocalCollection(collectionURI.replaceFirst("xmldb:exist://127.0.0.1", "")) : DatabaseManager.getCollection((String)collectionURI)))));
                }
                catch (XMLDBException xe) {
                    if (this.errorIfAbsent) {
                        throw new XPathException((Expression)this, "Could not locate collection: " + collectionURI, (Throwable)xe);
                    }
                    collection = null;
                }
            }
            if (collection == null && this.errorIfAbsent) {
                throw new XPathException((Expression)this, "Unable to find collection: " + collectionURI);
            }
        }
        Sequence s = Sequence.EMPTY_SEQUENCE;
        s = this.evalWithCollection(collection, args, contextSequence);
        return s;
    }

    protected abstract Sequence evalWithCollection(org.xmldb.api.base.Collection var1, Sequence[] var2, Sequence var3) throws XPathException;

    public static final org.xmldb.api.base.Collection createCollection(org.xmldb.api.base.Collection parentColl, String name) throws XMLDBException, XPathException {
        org.xmldb.api.base.Collection child = parentColl.getChildCollection(name);
        if (child == null) {
            CollectionManagementService mgtService = (CollectionManagementService)parentColl.getService("CollectionManagementService", "1.0");
            return mgtService.createCollection(name);
        }
        return child;
    }

    public static final org.xmldb.api.base.Collection createCollectionPath(org.xmldb.api.base.Collection parentColl, String relPath) throws XMLDBException, XPathException {
        org.xmldb.api.base.Collection current = parentColl;
        StringTokenizer tok = new StringTokenizer(new AnyURIValue(relPath).toXmldbURI().toString(), "/");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            current = XMLDBAbstractCollectionManipulator.createCollection(current, token);
        }
        return current;
    }
}

