/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.SchemaType;
import org.exist.security.internal.aider.UserAider;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.XMLDBException;

@Deprecated
public class XMLDBChangeUser
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(XMLDBChangeUser.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("change-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Change properties of an existing database user. The XQuery owner must have appropriate privileges to do this, e.g. having DBA role. $user-id is the username, $password is the password, $groups is the sequence of group memberships, $home-collection is the home collection. The username, $user-id, is mandatory. Non-empty values for the other parameters are optional, where if empty the existing value is used.", new SequenceType[]{new FunctionParameterSequenceType("user-id", 22, 2, "The user-id"), new FunctionParameterSequenceType("password", 22, 3, "The password"), new FunctionParameterSequenceType("groups", 22, 7, "The groups the user is member of"), new FunctionParameterSequenceType("home-collection", 22, 3, "The user's home collection")}, new SequenceType(11, 1), "$home-collection has no effect since 2.0. Use either sm:passwd for changing a password or sm:add-group-member to add a user to a group or sm:remove-group-member to remove a user from a group."), new FunctionSignature(new QName("change-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Change properties of an existing database user. The XQuery owner must have appropriate privileges to do this, e.g. having DBA role. $user-id is the username, $password is the password, $groups is the sequence of group memberships, The username, $user-id, is mandatory. Non-empty values for the other parameters are optional, where if empty the existing value is used.", new SequenceType[]{new FunctionParameterSequenceType("user-id", 22, 2, "The user-id"), new FunctionParameterSequenceType("password", 22, 3, "The password"), new FunctionParameterSequenceType("groups", 22, 7, "The groups the user is member of")}, new SequenceType(11, 1), "Use either sm:passwd for changing a password or sm:add-group-member to add a user to a group or sm:remove-group-member to remove a user from a group.")};

    public XMLDBChangeUser(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String userName = args[0].getStringValue();
        LocalCollection collection = null;
        try {
            collection = new LocalCollection(this.context.getSubject(), this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI);
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            Account oldUser = ums.getAccount(userName);
            if (oldUser == null) {
                logger.error("User " + userName + " not found");
                throw new XPathException((Expression)this, "User " + userName + " not found");
            }
            Group oldPrimaryGroup = oldUser.getDefaultGroup();
            UserAider user = oldPrimaryGroup != null ? new UserAider(oldUser.getName(), oldPrimaryGroup) : new UserAider(oldUser.getName());
            user.setUserMask(oldUser.getUserMask());
            for (SchemaType key : oldUser.getMetadataKeys()) {
                user.setMetadataValue(key, oldUser.getMetadataValue(key));
            }
            user.setEnabled(oldUser.isEnabled());
            if (!args[1].isEmpty()) {
                user.setPassword(args[1].getStringValue());
            } else {
                user.setEncodedPassword(oldUser.getPassword());
                user.setPasswordDigest(oldUser.getDigestPassword());
            }
            if (!args[2].isEmpty()) {
                SequenceIterator i = args[2].iterate();
                while (i.hasNext()) {
                    user.addGroup(i.nextItem().getStringValue());
                }
            } else {
                user.setGroups(oldUser.getGroups());
            }
            ums.updateAccount(user);
        }
        catch (XMLDBException xe) {
            logger.error("Failed to update user " + userName, (Throwable)xe);
            throw new XPathException((Expression)this, "Failed to update user " + userName, (Throwable)xe);
        }
        finally {
            if (null != collection) {
                try {
                    collection.close();
                }
                catch (XMLDBException xmldbe) {
                    logger.warn((Object)xmldbe);
                }
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

