/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBCreateCollection
extends XMLDBAbstractCollectionManipulator {
    private static final Logger logger = LogManager.getLogger(XMLDBCreateCollection.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("create-collection", "http://exist-db.org/xquery/xmldb", "xmldb"), "Create a new collection with name $new-collection as a child of $target-collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.Returns the path to the new collection if successfully created, otherwise the empty sequence.", new SequenceType[]{new FunctionParameterSequenceType("target-collection-uri", 22, 2, "The target collection URI"), new FunctionParameterSequenceType("new-collection", 22, 2, "The name of the new collection to create")}, new FunctionReturnSequenceType(22, 3, "the path to the new collection if successfully created, otherwise the empty sequence"));

    public XMLDBCreateCollection(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        String collectionName = args[1].getStringValue();
        try {
            Collection newCollection = XMLDBCreateCollection.createCollectionPath(collection, collectionName);
            if (newCollection == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            return new StringValue(newCollection.getName());
        }
        catch (XMLDBException e) {
            logger.error("Unable to create new collection " + collectionName, (Throwable)e);
            throw new XPathException((Expression)this, "failed to create new collection " + collectionName + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

