/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeSet;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class XMLDBDefragment
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(XMLDBDefragment.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("defragment", "http://exist-db.org/xquery/xmldb", "xmldb"), "Start a defragmentation run on each document which has a node in $nodes. Fragmentation may occur if nodes are inserted into a document using XQuery update extensions. The second argument specifies the minimum number of fragmented pages which should be in a document before it is considered for defragmentation. Please note that defragmenting a document changes its internal structure, so any references to this document will become invalid, in particular, variables pointing to some nodes in the document.", new SequenceType[]{new FunctionParameterSequenceType("nodes", -1, 6, "The sequence of nodes from the documents to defragment"), new FunctionParameterSequenceType("integer", 31, 2, "The minimum number of fragmented pages required before defragmenting")}, new SequenceType(11, 1)), new FunctionSignature(new QName("defragment", "http://exist-db.org/xquery/xmldb", "xmldb"), "Start a defragmentation run on each document which has a node in $nodes. Fragmentation may occur if nodes are inserted into a document using XQuery update extensions. Please note that defragmenting a document changes its internal structure, so any references to this document will become invalid, in particular, variables pointing to some nodes in the document.", new SequenceType[]{new FunctionParameterSequenceType("nodes", -1, 6, "The sequence of nodes from the documents to defragment")}, new SequenceType(11, 1))};

    public XMLDBDefragment(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        NodeSet nodes = args[0].toNodeSet();
        DocumentSet docs = nodes.getDocumentSet();
        try {
            if (args.length > 1) {
                int splitCount = ((IntegerValue)args[1].itemAt(0)).getInt();
                Modification.checkFragmentation(this.context, docs, splitCount);
            } else {
                Modification.checkFragmentation(this.context, docs);
            }
        }
        catch (EXistException e) {
            logger.error("An error occurred while defragmenting documents: " + e.getMessage());
            throw new XPathException((Expression)this, "An error occurred while defragmenting documents: " + e.getMessage(), (Throwable)e);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

