/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.UpdateListener;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class XMLDBDocument
extends Function {
    private static final Logger logger = LogManager.getLogger(XMLDBDocument.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("document", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the documents $document-uris in the input sequence. Collection URIs can be specified either as a simple collection path or an XMLDB URI.If the input sequence is empty, the function will load all documents in the database.", new SequenceType[]{new FunctionParameterSequenceType("document-uris", 22, 6, "The document URIs")}, new FunctionReturnSequenceType(-1, 7, "the documents"), true, "See the standard fn:doc() function");
    private List<String> cachedArgs = null;
    private Sequence cached = null;
    private DocumentSet cachedDocs = null;
    private UpdateListener listener = null;

    public XMLDBDocument(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public int getDependencies() {
        return 1;
    }

    @Override
    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        DocumentSet docs = null;
        Sequence result = null;
        boolean lockOnLoad = this.context.lockDocumentsOnLoad();
        boolean cacheIsValid = false;
        if (this.getArgumentCount() == 0) {
            DefaultDocumentSet mdocs = new DefaultDocumentSet();
            try {
                this.context.getBroker().getAllXMLResources(mdocs);
            }
            catch (PermissionDeniedException pde) {
                LOG.error(pde.getMessage(), (Throwable)pde);
                throw new XPathException((Expression)this, (Throwable)pde);
            }
            docs = mdocs;
        } else {
            List<String> args = this.getParameterValues(contextSequence, contextItem);
            if (this.cachedArgs != null) {
                cacheIsValid = this.compareArguments(this.cachedArgs, args);
            }
            if (cacheIsValid) {
                result = this.cached;
                docs = this.cachedDocs;
            } else {
                DefaultDocumentSet mdocs = new DefaultDocumentSet();
                for (int i = 0; i < args.size(); ++i) {
                    try {
                        DocumentImpl doc;
                        String next = args.get(i);
                        XmldbURI nextUri = new AnyURIValue(next).toXmldbURI();
                        if (nextUri.getCollectionPath().length() == 0) {
                            throw new XPathException((Expression)this, "Invalid argument to xmldb:document() function: empty string is not allowed here.");
                        }
                        if (nextUri.numSegments() == 1) {
                            nextUri = this.context.getBaseURI().toXmldbURI().resolveCollectionPath(nextUri);
                        }
                        if ((doc = this.context.getBroker().getResource(nextUri, 4)) == null) {
                            if (!this.context.isRaiseErrorOnFailedRetrieval()) continue;
                            throw new XPathException((Expression)this, ErrorCodes.FODC0002, "can not access '" + nextUri + "'");
                        }
                        mdocs.add(doc);
                        continue;
                    }
                    catch (XPathException e) {
                        e.setLocation(this.line, this.column);
                        logger.error("From AnyURIValue constructor:", (Throwable)e);
                        throw e;
                    }
                    catch (PermissionDeniedException e) {
                        logger.error("Permission denied", (Throwable)e);
                        throw new XPathException((Expression)this, "Permission denied: unable to load document " + args.get(i));
                    }
                }
                docs = mdocs;
                this.cachedArgs = args;
            }
        }
        try {
            if (!cacheIsValid) {
                docs.lock(this.context.getBroker(), lockOnLoad);
            }
            if (result == null) {
                result = new ExtArrayNodeSet(docs.getDocumentCount(), 1);
                Iterator<DocumentImpl> i = docs.getDocumentIterator();
                while (i.hasNext()) {
                    DocumentImpl doc = i.next();
                    result.add(new NodeProxy(doc));
                    if (!lockOnLoad) continue;
                    this.context.addLockedDocument(doc);
                }
            }
        }
        catch (LockException e) {
            logger.error("Could not acquire lock on document set", (Throwable)e);
            throw new XPathException((Expression)this, "Could not acquire lock on document set.");
        }
        finally {
            if (!cacheIsValid && !lockOnLoad) {
                docs.unlock();
            }
        }
        this.cached = result;
        this.cachedDocs = docs;
        this.registerUpdateListener();
        return result;
    }

    private List<String> getParameterValues(Sequence contextSequence, Item contextItem) throws XPathException {
        ArrayList<String> args = new ArrayList<String>(this.getArgumentCount() + 10);
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Sequence seq = this.getArgument(i).eval(contextSequence, contextItem);
            SequenceIterator j = seq.iterate();
            while (j.hasNext()) {
                Item next = j.nextItem();
                args.add(next.getStringValue());
            }
        }
        return args;
    }

    private boolean compareArguments(List<String> args1, List<String> args2) {
        if (args1.size() != args2.size()) {
            return false;
        }
        for (int i = 0; i < args1.size(); ++i) {
            String arg2;
            String arg1 = args1.get(i);
            if (arg1.equals(arg2 = args2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void registerUpdateListener() {
        if (this.listener == null) {
            this.listener = new UpdateListener(){

                @Override
                public void documentUpdated(DocumentImpl document, int event) {
                    XMLDBDocument.this.cachedArgs = null;
                    XMLDBDocument.this.cached = null;
                    XMLDBDocument.this.cachedDocs = null;
                }

                @Override
                public void unsubscribe() {
                    XMLDBDocument.this.listener = null;
                }

                @Override
                public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
                }

                @Override
                public void debug() {
                    logger.debug("UpdateListener: Line: " + XMLDBDocument.this.getLine() + ": " + XMLDBDocument.this.toString());
                }
            };
            this.context.registerUpdateListener(this.listener);
        }
    }

    @Override
    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        if (!postOptimization) {
            this.cached = null;
            this.cachedArgs = null;
            this.cachedDocs = null;
            this.listener = null;
        }
    }
}

