/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBGetChildCollections
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBGetChildCollections.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-child-collections", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the names of the child collections in the collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI")}, new FunctionReturnSequenceType(22, 7, "the sequence of child collection names"));

    public XMLDBGetChildCollections(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence result = new ValueSequence();
        try {
            String[] collections = collection.listChildCollections();
            for (int i = 0; i < collections.length; ++i) {
                result.add(new StringValue(collections[i]));
            }
            return result;
        }
        catch (XMLDBException e) {
            throw new XPathException((Expression)this, "Failed to retrieve child collections", (Throwable)e);
        }
    }
}

