/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.lock.Lock;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class XMLDBGetMimeType
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBGetMimeType.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-mime-type", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the MIME type if available of the resource $resource-uri, otherwise the empty sequence. Resource URIs can be specified either as a simple collection path, an XMLDB URI or any URI.", new SequenceType[]{new FunctionParameterSequenceType("resource-uri", 25, 2, "The resource URI")}, new FunctionReturnSequenceType(22, 3, "the mime-type if available, otherwise the empty sequence"));

    public XMLDBGetMimeType(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String path = new AnyURIValue(args[0].itemAt(0).getStringValue()).toString();
        if (path.matches("^[a-z]+://.*")) {
            MimeTable mimeTable = MimeTable.getInstance();
            MimeType mimeType = mimeTable.getContentTypeFor(path);
            if (mimeType != null) {
                return new StringValue(mimeType.getName());
            }
        } else {
            DocumentImpl doc = null;
            try {
                XmldbURI pathUri = XmldbURI.xmldbUriFor(path);
                pathUri = this.context.getBaseURI().toXmldbURI().resolveCollectionPath(pathUri);
                doc = this.context.getBroker().getXMLResource(pathUri, Lock.LockMode.READ_LOCK);
                if (doc != null) {
                    StringValue stringValue = new StringValue(doc.getMetadata().getMimeType());
                    return stringValue;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new XPathException((Expression)this, (Throwable)e);
            }
            finally {
                if (doc != null) {
                    doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

