/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.Permission;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.PermissionsFunction;
import org.exist.xquery.functions.xmldb.XMLDBPermissions;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

@Deprecated
public class XMLDBGetUserOrGroup
extends XMLDBPermissions {
    protected static final FunctionParameterSequenceType OWNER_COLLECTION_ARG = new FunctionParameterSequenceType("collection-uri", 11, 2, "The collection URI");
    protected static final FunctionParameterSequenceType GROUP_COLLECTION_ARG = new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI");
    protected static final FunctionParameterSequenceType RESOURCE_ARG = new FunctionParameterSequenceType("resource", 22, 2, "The resource");
    protected static final FunctionReturnSequenceType OWNER_RETURN_TYPE = new FunctionReturnSequenceType(22, 3, "the user-id");
    protected static final FunctionReturnSequenceType GROUP_RETURN_TYPE = new FunctionReturnSequenceType(22, 3, "the owner group");
    protected static final Logger logger = LogManager.getLogger(XMLDBGetUserOrGroup.class);
    public static final FunctionSignature[] getGroupSignatures = new FunctionSignature[]{new FunctionSignature(new QName("get-group", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the owner group of the collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{GROUP_COLLECTION_ARG}, (SequenceType)GROUP_RETURN_TYPE, PermissionsFunction.FNS_GET_PERMISSIONS), new FunctionSignature(new QName("get-group", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the owner group of the resource $resource in the collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{GROUP_COLLECTION_ARG, RESOURCE_ARG}, (SequenceType)GROUP_RETURN_TYPE, PermissionsFunction.FNS_GET_PERMISSIONS)};
    public static final FunctionSignature[] getOwnerSignatures = new FunctionSignature[]{new FunctionSignature(new QName("get-owner", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the owner user-id of the collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{OWNER_COLLECTION_ARG}, (SequenceType)OWNER_RETURN_TYPE, PermissionsFunction.FNS_GET_PERMISSIONS), new FunctionSignature(new QName("get-owner", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the owner user-id of the resource $resource in collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{OWNER_COLLECTION_ARG, RESOURCE_ARG}, (SequenceType)OWNER_RETURN_TYPE, PermissionsFunction.FNS_GET_PERMISSIONS)};

    public XMLDBGetUserOrGroup(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Permission perm = this.getPermissions(collection, args);
            if ("get-owner".equals(this.getSignature().getName().getLocalPart())) {
                return new StringValue(perm.getOwner().getName());
            }
            return new StringValue(perm.getGroup().getName());
        }
        catch (XMLDBException xe) {
            logger.error("Unable to retrieve resource permissions");
            throw new XPathException((Expression)this, "Unable to retrieve resource permissions", (Throwable)xe);
        }
    }
}

