/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.Group;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.FindGroupFunction;
import org.exist.xquery.functions.xmldb.XMLDBCreateUser;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

@Deprecated
public class XMLDBGroupExists
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBCreateUser.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("group-exists", "http://exist-db.org/xquery/xmldb", "xmldb"), "Determines whether a group exists. $group is the group name, The current user must have permission to access the group, i.e. be a member of the group or DBA", new SequenceType[]{new FunctionParameterSequenceType("group", 22, 2, "The group name")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true() or false() indicating the outcome of the operation"), FindGroupFunction.FNS_GROUP_EXISTS)};

    public XMLDBGroupExists(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String groupName = args[0].getStringValue();
        DBBroker broker = this.context.getBroker();
        Subject currentUser = broker.getCurrentSubject();
        if (currentUser.hasGroup(groupName)) {
            return BooleanValue.TRUE;
        }
        if (currentUser.hasDbaRole()) {
            SecurityManager sm = broker.getBrokerPool().getSecurityManager();
            Group group = sm.getGroup(groupName);
            return BooleanValue.valueOf(group != null);
        }
        throw new XPathException("You do not have permission to determine if the group exists");
    }
}

