/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBHasLock
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBHasLock.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("document-has-lock", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the user-id of the user that holds a write lock on the resource $resource in the collection $collection-uri.  If no lock is in place, the empty sequence is returned. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("resource", 22, 2, "The resource")}, new FunctionReturnSequenceType(22, 3, "the user id of the lock owner, otherwise if not locked the empty sequence")), new FunctionSignature(new QName("clear-lock", "http://exist-db.org/xquery/xmldb", "xmldb"), "Removes the user lock on the resource $resource in the collection $collection-uri.  If no lock is in place, the empty sequence is returned. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("resource", 22, 2, "The resource")}, new FunctionReturnSequenceType(22, 3, "the user id of the previous lock owner, otherwise if not locked the empty sequence"))};

    public XMLDBHasLock(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            Resource res = collection.getResource(new AnyURIValue(args[1].getStringValue()).toXmldbURI().toString());
            if (res != null) {
                String lockUser = ums.hasUserLock(res);
                if (lockUser != null && this.isCalledAs("clear-lock")) {
                    ums.unlockResource(res);
                }
                return lockUser == null ? Sequence.EMPTY_SEQUENCE : new StringValue(lockUser);
            }
            logger.error("Unable to locate resource " + args[1].getStringValue());
            throw new XPathException((Expression)this, "Unable to locate resource " + args[1].getStringValue());
        }
        catch (XMLDBException e) {
            logger.error("Failed to retrieve user lock");
            throw new XPathException((Expression)this, "Failed to retrieve user lock", (Throwable)e);
        }
    }
}

