/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.Account;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.GroupMembershipFunction;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.XMLDBException;

@Deprecated
public class XMLDBIsAdmin
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBIsAdmin.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("is-admin-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns true() if user $user-id has DBA role, false() otherwise.", new SequenceType[]{new FunctionParameterSequenceType("user-id", 22, 2, "The user-id")}, (SequenceType)new FunctionReturnSequenceType(23, 3, "true() if user has DBA role, false() otherwise"), GroupMembershipFunction.FNS_IS_DBA);

    public XMLDBIsAdmin(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        BooleanValue booleanValue;
        String userName = args[0].getStringValue();
        LocalCollection collection = null;
        try {
            collection = new LocalCollection(this.context.getSubject(), this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI);
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            Account user = ums.getAccount(userName);
            if (user == null) {
                Sequence sequence = Sequence.EMPTY_SEQUENCE;
                return sequence;
            }
            booleanValue = user.hasDbaRole() ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        catch (XMLDBException xe) {
            logger.error("Failed to access user " + userName);
            throw new XPathException((Expression)this, "Failed to access user " + userName, (Throwable)xe);
        }
        finally {
            if (null != collection) {
                try {
                    collection.close();
                }
                catch (XMLDBException xMLDBException) {}
            }
        }
        return booleanValue;
    }
}

