/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.DirectoryScanner;
import org.exist.util.FileUtils;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.EXistResource;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBLoadFromPattern
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBLoadFromPattern.class);
    protected static final QName FUNCTION_NAME = new QName("store-files-from-pattern", "http://exist-db.org/xquery/xmldb", "xmldb");
    protected static final String FUNCTION_DESCRIPTION = "Stores new resources into the database. Resources are read from the server's file system, using file patterns. The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document(s).";
    protected static final SequenceType PARAM_COLLECTION = new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection-uri where resources should be stored. Collection URIs can be specified either as a simple collection path or an XMLDB URI.");
    protected static final SequenceType PARAM_FS_DIRECTORY = new FunctionParameterSequenceType("directory", 22, 2, "The directory in the file system from where the files are read.");
    protected static final SequenceType PARAM_FS_PATTERN = new FunctionParameterSequenceType("pattern", 22, 6, "The file matching pattern. Based on code from Apache's Ant, thus following the same conventions. For example: *.xml matches any file ending with .xml in the current directory, **/*.xml matches files in any directory below the current one");
    protected static final SequenceType PARAM_MIME_TYPE = new FunctionParameterSequenceType("mime-type", 22, 3, "If the mime-type is something other than 'text/xml' or 'application/xml', the resource will be stored as a binary resource.");
    protected static final SequenceType PARAM_PRESERVE_STRUCTURE = new FunctionParameterSequenceType("preserve-structure", 23, 2, "If preserve-structure is true(), the filesystem directory structure will be mirrored in the collection. Otherwise all the matching resources, including the ones in sub-directories, will be stored in the collection given in the first argument flatly.");
    protected static final SequenceType PARAM_EXCLUDES = new FunctionParameterSequenceType("exclude", 22, 7, "A sequence of file patterns to exclude");
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(22, 7, "the sequence of document paths");
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(FUNCTION_NAME, "Stores new resources into the database. Resources are read from the server's file system, using file patterns. The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document(s).", new SequenceType[]{PARAM_COLLECTION, PARAM_FS_DIRECTORY, PARAM_FS_PATTERN}, RETURN_TYPE), new FunctionSignature(FUNCTION_NAME, "Stores new resources into the database. Resources are read from the server's file system, using file patterns. The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document(s).", new SequenceType[]{PARAM_COLLECTION, PARAM_FS_DIRECTORY, PARAM_FS_PATTERN, PARAM_MIME_TYPE}, RETURN_TYPE), new FunctionSignature(FUNCTION_NAME, "Stores new resources into the database. Resources are read from the server's file system, using file patterns. The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document(s).", new SequenceType[]{PARAM_COLLECTION, PARAM_FS_DIRECTORY, PARAM_FS_PATTERN, PARAM_MIME_TYPE, PARAM_PRESERVE_STRUCTURE}, RETURN_TYPE), new FunctionSignature(FUNCTION_NAME, "Stores new resources into the database. Resources are read from the server's file system, using file patterns. The function returns a sequence of all document paths added to the db. These can be directly passed to fn:doc() to retrieve the document(s).", new SequenceType[]{PARAM_COLLECTION, PARAM_FS_DIRECTORY, PARAM_FS_PATTERN, PARAM_MIME_TYPE, PARAM_PRESERVE_STRUCTURE, PARAM_EXCLUDES}, RETURN_TYPE)};

    public XMLDBLoadFromPattern(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    protected Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        Path baseDir = Paths.get(args[1].getStringValue(), new String[0]).normalize();
        logger.debug("Loading files from directory: " + baseDir.toAbsolutePath().toString());
        MimeType mimeTypeFromArgs = null;
        if (this.getSignature().getArgumentCount() > 3 && args[3].hasOne()) {
            String mimeTypeParam = args[3].getStringValue();
            mimeTypeFromArgs = MimeTable.getInstance().getContentType(mimeTypeParam);
            if (mimeTypeFromArgs == null) {
                throw new XPathException((Expression)this, "Unknown mime type specified: " + mimeTypeParam);
            }
        }
        boolean keepDirStructure = false;
        if (this.getSignature().getArgumentCount() >= 5) {
            keepDirStructure = args[4].effectiveBooleanValue();
        }
        ArrayList<String> excludes = new ArrayList<String>();
        if (this.getSignature().getArgumentCount() == 6) {
            SequenceIterator i = args[5].iterate();
            while (i.hasNext()) {
                excludes.add(i.nextItem().getStringValue());
            }
        }
        ValueSequence stored = new ValueSequence();
        try {
            Sequence patterns = args[2];
            SequenceIterator i = patterns.iterate();
            while (i.hasNext()) {
                String pattern = i.nextItem().getStringValue();
                List<Path> files = DirectoryScanner.scanDir(baseDir, pattern);
                logger.debug("Found: " + files.size());
                Collection col = collection;
                String prevDir = null;
                for (Path file : files) {
                    try {
                        MimeType mimeType;
                        String relDir;
                        logger.debug(file.toAbsolutePath().toString());
                        String relPath = file.toString().substring(baseDir.toString().length());
                        int p = relPath.lastIndexOf(File.separatorChar);
                        if (XMLDBLoadFromPattern.checkExcludes(excludes, relPath)) continue;
                        if (p >= 0) {
                            relDir = relPath.substring(0, p);
                            relDir = relDir.replace(File.separatorChar, '/');
                        } else {
                            relDir = relPath;
                        }
                        if (keepDirStructure && (prevDir == null || !relDir.equals(prevDir))) {
                            col = XMLDBLoadFromPattern.createCollectionPath(collection, relDir);
                            prevDir = relDir;
                        }
                        if ((mimeType = mimeTypeFromArgs) == null && (mimeType = MimeTable.getInstance().getContentTypeFor(FileUtils.fileName(file))) == null) {
                            mimeType = MimeType.BINARY_TYPE;
                        }
                        Resource resource = col.createResource(FileUtils.fileName(file), mimeType.getXMLDBType());
                        resource.setContent((Object)file.toFile());
                        ((EXistResource)resource).setMimeType(mimeType.getName());
                        col.storeResource(resource);
                        stored.add(new StringValue(col.getName() + "/" + resource.getId()));
                    }
                    catch (XMLDBException e) {
                        logger.error("Could not store file " + file.toAbsolutePath() + ": " + e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return stored;
    }

    private static boolean checkExcludes(List<String> excludes, String path) {
        if (excludes == null || excludes.isEmpty()) {
            return false;
        }
        if (path.charAt(0) == File.separatorChar) {
            path = path.substring(1);
        }
        boolean skip = false;
        for (String exclude : excludes) {
            if (!DirectoryScanner.match(exclude, path)) continue;
            skip = true;
            break;
        }
        return skip;
    }
}

