/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class XMLDBMatchCollection
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBMatchCollection.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("match-collection", "http://exist-db.org/xquery/xmldb", "xmldb"), "Looks for collection names in the collection index that match the provided regexp", new SequenceType[]{new FunctionParameterSequenceType("regexp", 22, 2, "The expression to use for matching collection names")}, new FunctionReturnSequenceType(22, 7, "The names of the collections that match the expression"));

    public XMLDBMatchCollection(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result = Sequence.EMPTY_SEQUENCE;
        String regexp = args[0].getStringValue();
        List<String> collectionNames = this.context.getBroker().findCollectionsMatching(regexp);
        if (collectionNames.size() > 0) {
            result = this.copyListToValueSequence(collectionNames);
        }
        return result;
    }

    private Sequence copyListToValueSequence(List<String> collectionNames) {
        ValueSequence seq = new ValueSequence(collectionNames.size());
        for (String collectionName : collectionNames) {
            seq.add(new StringValue(collectionName));
        }
        return seq;
    }
}

