/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.Permission;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.securitymanager.PermissionsFunction;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

@Deprecated
public class XMLDBPermissions
extends XMLDBAbstractCollectionManipulator {
    protected static final FunctionParameterSequenceType ARG_COLLECTION = new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection-uri");
    protected static final FunctionParameterSequenceType ARG_RESOURCE = new FunctionParameterSequenceType("resource", 22, 2, "The resource");
    protected static final Logger logger = LogManager.getLogger(XMLDBPermissions.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-permissions", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the permissions assigned to the collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{ARG_COLLECTION}, (SequenceType)new FunctionReturnSequenceType(38, 3, "the collection permissions"), PermissionsFunction.FNS_GET_PERMISSIONS), new FunctionSignature(new QName("get-permissions", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the permissions assigned to the resource $resource in collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI.", new SequenceType[]{ARG_COLLECTION, ARG_RESOURCE}, (SequenceType)new FunctionReturnSequenceType(38, 3, "the resource permissions"), PermissionsFunction.FNS_GET_PERMISSIONS)};

    public XMLDBPermissions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            Permission perm = this.getPermissions(collection, args);
            return new IntegerValue(perm.getMode(), 38);
        }
        catch (XMLDBException xe) {
            logger.error("Unable to retrieve resource permissions");
            throw new XPathException((Expression)this, "Unable to retrieve resource permissions", (Throwable)xe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Permission getPermissions(Collection collection, Sequence[] args) throws XMLDBException, XPathException {
        UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
        if (this.getSignature().getArgumentCount() != 2) return ums.getPermissions(collection);
        Resource res = collection.getResource(args[1].getStringValue());
        if (res == null) throw new XPathException((Expression)this, "Unable to locate resource " + args[1].getStringValue());
        return ums.getPermissions(res);
    }
}

