/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;

public class XMLDBRegisterDatabase
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(XMLDBRegisterDatabase.class);
    public static final FunctionSignature signature = new FunctionSignature(new QName("register-database", "http://exist-db.org/xquery/xmldb", "xmldb"), "Registers an XMLDB driver class with the XMLDB Database Manager. This is only required if you want to access a database instance different from the one that executes the XQuery.", new SequenceType[]{new FunctionParameterSequenceType("driver", 22, 2, "The DB driver"), new FunctionParameterSequenceType("create-db", 23, 2, "The flag to create the db if it does not exist")}, new FunctionReturnSequenceType(23, 2, "true() if successfully registered, false() otherwise"));

    public XMLDBRegisterDatabase(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String driverName = args[0].getStringValue();
        boolean createDatabase = args[1].effectiveBooleanValue();
        try {
            Class<?> driver = Class.forName(driverName);
            Database database = (Database)driver.newInstance();
            database.setProperty("create-database", createDatabase ? "true" : "false");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (Exception e) {
            logger.error("failed to initiate XMLDB database driver: " + driverName);
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }
}

