/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xmldb.IndexQueryService;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class XMLDBReindex
extends XMLDBAbstractCollectionManipulator {
    protected static final Logger logger = LogManager.getLogger(XMLDBReindex.class);
    public static final FunctionSignature FNS_REINDEX_COLLECTION = new FunctionSignature(new QName("reindex", "http://exist-db.org/xquery/xmldb", "xmldb"), "Reindex collection $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI. The XQuery owner must have appropriate privileges to do this, e.g. having DBA role.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI")}, new FunctionReturnSequenceType(23, 2, "true() if successfully reindexed, false() otherwise"));
    public static final FunctionSignature FNS_REINDEX_DOCUMENT = new FunctionSignature(new QName("reindex", "http://exist-db.org/xquery/xmldb", "xmldb"), "Reindex document $doc-uri from $collection-uri. Collection URIs can be specified either as a simple collection path or an XMLDB URI. Resource URIs can be specified either as a simple collection path, an XMLDB URI or any URI. The XQuery owner must have appropriate privileges to do this, e.g. having DBA role.", new SequenceType[]{new FunctionParameterSequenceType("collection-uri", 22, 2, "The collection URI"), new FunctionParameterSequenceType("doc-uri", 22, 2, "The document URI")}, new FunctionReturnSequenceType(23, 2, "true() if successfully reindexed, false() otherwise"));

    public XMLDBReindex(XQueryContext context, FunctionSignature signature) {
        super(context, signature, false);
    }

    @Override
    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            logger.error("Permission denied, user '" + this.context.getSubject().getName() + "' must be a DBA to reindex the database");
            return BooleanValue.FALSE;
        }
        if (collection == null) {
            logger.error("Collection " + args[0].getStringValue() + " does not exist.");
            return BooleanValue.FALSE;
        }
        try {
            IndexQueryService iqs = (IndexQueryService)collection.getService("IndexQueryService", "1.0");
            if (args.length == 2) {
                iqs.reindexDocument(args[1].getStringValue());
            } else {
                iqs.reindexCollection();
            }
        }
        catch (XMLDBException xe) {
            logger.error("Unable to reindex collection", (Throwable)xe);
            return BooleanValue.FALSE;
        }
        return BooleanValue.TRUE;
    }
}

